/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.alibaba.fastjson.JSON;
import com.jsmframe.annotation.RestAnn;
import com.jsmframe.annotation.Transaction;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.dao.model.OptLog;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.rest.resp.ExcelResp;
import com.jsmframe.rest.resp.FileResp;
import com.jsmframe.rest.resp.JsonResp;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.rest.resp.TextResp;
import com.jsmframe.rest.resp.XmlResp;
import com.jsmframe.service.LogService;
import com.jsmframe.session.Session;
import com.jsmframe.session.SessionUser;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.HttpClientUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.TransactionUtil;
import com.jsmframe.utils.ValidateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.multipart.MultipartFile;

public class RestAop {
    private static Logger logger = LogUtil.log(RestAop.class);
    private PlatformTransactionManager transactionManager;
    private static String REQUEST_PREFIX = "request.";
    private static String SESSION_PREFIX = "session.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        logger.debug("intercept");
        Object object2 = null;
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        RestAnn restAnn = method.getAnnotation(RestAnn.class);
        if (restAnn == null) {
            return proceedingJoinPoint.proceed();
        }
        if (restAnn.validate() && !StringUtil.isEmpty((String)(object = this.validate(proceedingJoinPoint)))) {
            RestResp restResp = new RestResp();
            restResp.setPair(BasePairConsts.PARAMS_ERROR);
            restResp.result = object;
            logger.debug("resp:" + JSON.toJSONString(restResp));
            return restResp;
        }
        if (restAnn.sync()) {
            object = method;
            synchronized (object) {
                object2 = this.process(proceedingJoinPoint, object2, method, restAnn);
            }
        } else {
            object2 = this.process(proceedingJoinPoint, object2, method, restAnn);
        }
        if (!StringUtil.isEmpty(restAnn.log())) {
            object = new OptLog();
            ((OptLog)object).ip = WebContext.getRmoteIp();
            Session session = WebContext.currentSession();
            ((OptLog)object).mac = session != null ? (String)session.get("mac") : "";
            ((OptLog)object).funcName = restAnn.logType();
            SessionUser sessionUser = WebContext.currentUser();
            ((OptLog)object).uid = sessionUser != null ? sessionUser.getUid().toString() : "";
            ((OptLog)object).optDesc = this.formatLog(restAnn.log());
            ((OptLog)object).time = new Date();
            LogService logService = SpringContext.getBean(LogService.class);
            String string = AppContext.get("logger.url");
            if (logService != null) {
                logService.addLog((OptLog)object);
            } else if (StringUtil.isEmpty(string)) {
                HttpClientUtil.post(string, object);
            } else {
                logger.error("LogService or logger.url not found! you can implement LogService Or add a logger.url in app.properties");
            }
        }
        return object2;
    }

    private String formatLog(String string) {
        Pattern pattern = Pattern.compile("#\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(string);
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            hashSet.add(matcher.group(1));
        }
        for (String string2 : hashSet) {
            String string3 = this.getLogVarValue(string2);
            if (StringUtil.isEmpty(string3)) continue;
            string = string.replaceAll("#\\{" + string2 + "\\}", string3);
        }
        return string;
    }

    private String getLogVarValue(String string) {
        if (string.startsWith(REQUEST_PREFIX)) {
            return StringUtil.toString(WebContext.getRequest().getAttribute(string.replace(REQUEST_PREFIX, "")));
        }
        if (string.startsWith(SESSION_PREFIX)) {
            return StringUtil.toString(WebContext.currentSession().get(string.replace(SESSION_PREFIX, "")));
        }
        String string2 = StringUtil.toString(WebContext.getRequest().getAttribute(string));
        if (StringUtil.isEmpty(string2)) {
            string2 = StringUtil.toString(WebContext.currentSession().get(string));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process(ProceedingJoinPoint proceedingJoinPoint, Object object, Method method, RestAnn restAnn) throws Throwable, Exception {
        TransactionStatus transactionStatus = null;
        JedisService jedisService = null;
        try {
            if (!StringUtil.isEmpty(restAnn.clusterSyncLock())) {
                jedisService = SpringContext.getBean(JedisService.class);
                jedisService.lock(restAnn.clusterSyncLock());
            }
            if (!restAnn.transaction().equals((Object)Transaction.NONE)) {
                String string = "transactionManager";
                if (!StringUtil.isEmpty(restAnn.transManagerName())) {
                    string = restAnn.transManagerName();
                }
                this.transactionManager = (PlatformTransactionManager)SpringContext.getBean(string);
                transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)this.createTransactionDefinition(restAnn));
                TransactionUtil.setTransactionStatus(transactionStatus);
            }
            object = this.execMethod(proceedingJoinPoint);
            if (transactionStatus != null && !transactionStatus.isCompleted()) {
                if (transactionStatus.isRollbackOnly()) {
                    logger.warn("transaction rollback!");
                    this.transactionManager.rollback(transactionStatus);
                } else {
                    this.transactionManager.commit(transactionStatus);
                }
            }
        }
        catch (Exception exception) {
            if (transactionStatus != null) {
                logger.error("error: transaction rollback!", (Throwable)exception);
                this.transactionManager.rollback(transactionStatus);
            }
            object = this.dealException(exception, object, method);
        }
        finally {
            TransactionUtil.removeTransactionStatus();
            if (jedisService != null) {
                jedisService.unlock(restAnn.clusterSyncLock());
            }
        }
        logger.debug("resp:" + JSON.toJSONString((Object)object));
        return object;
    }

    private Object execMethod(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object = proceedingJoinPoint.proceed();
        if (object == null) {
            return object;
        }
        if (object instanceof FileResp) {
            FileResp fileResp = (FileResp)object;
            this.outputFile(fileResp);
            logger.debug("FileResp:{}", (Object)fileResp.fileName);
        } else if (object instanceof TextResp) {
            TextResp textResp = (TextResp)object;
            this.outputText(textResp);
            logger.debug("textResp:{}", (Object)textResp.text);
        } else if (object instanceof JsonResp) {
            JsonResp jsonResp = (JsonResp)object;
            this.outputJson(jsonResp);
            logger.debug("jsonResp:{}", (Object)jsonResp.jsonStr);
        } else if (object instanceof XmlResp) {
            XmlResp xmlResp = (XmlResp)object;
            this.outputXml(xmlResp);
            logger.debug("xmlResp:{}", (Object)xmlResp.xml);
        } else if (object instanceof ExcelResp) {
            ExcelResp excelResp = (ExcelResp)object;
            this.outputExcel(excelResp);
            logger.debug("excelResp:{}", (Object)excelResp.fileName);
        } else {
            if (object instanceof RestResp) {
                return object;
            }
            logger.warn("unkown response type!");
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputExcel(ExcelResp excelResp) {
        HttpServletResponse httpServletResponse = WebContext.getResponse();
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + EncryptUtil.urlEncode(excelResp.fileName));
        httpServletResponse.setContentType("application/octet-stream;charset=UTF-8");
        if (excelResp.workbook != null) {
            try {
                excelResp.workbook.write((OutputStream)httpServletResponse.getOutputStream());
            }
            catch (IOException iOException) {
                logger.error("write workbook error! {}", (Object)excelResp.fileName);
            }
            finally {
                try {
                    excelResp.workbook.close();
                }
                catch (IOException iOException) {
                    logger.error("close workbook error! {}", (Object)excelResp.fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputXml(XmlResp xmlResp) {
        try (PrintWriter printWriter = null;){
            WebContext.getResponse().setContentType("text/xml;charset=UTF-8");
            printWriter = WebContext.getResponse().getWriter();
            printWriter.write(xmlResp.xml);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputText(TextResp textResp) {
        try (PrintWriter printWriter = null;){
            WebContext.getResponse().setContentType("text/plain;charset=UTF-8");
            printWriter = WebContext.getResponse().getWriter();
            printWriter.write(textResp.text);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputJson(JsonResp jsonResp) {
        try (PrintWriter printWriter = null;){
            WebContext.getResponse().setContentType("application/json;charset=UTF-8");
            printWriter = WebContext.getResponse().getWriter();
            printWriter.write(jsonResp.jsonStr);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputFile(FileResp fileResp) {
        HttpServletResponse httpServletResponse = WebContext.getResponse();
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + EncryptUtil.urlEncode(fileResp.fileName));
        httpServletResponse.setCharacterEncoding("UTF-8");
        ServletOutputStream servletOutputStream = null;
        InputStream inputStream = null;
        PrintWriter printWriter = null;
        try {
            if (fileResp.outputObject instanceof String) {
                printWriter = httpServletResponse.getWriter();
                printWriter.print((String)fileResp.outputObject);
            } else if (fileResp.outputObject instanceof InputStream) {
                servletOutputStream = httpServletResponse.getOutputStream();
                int n = 0;
                byte[] byArray = new byte[1024];
                inputStream = (InputStream)fileResp.outputObject;
                while ((n = inputStream.read(byArray)) != -1) {
                    servletOutputStream.write(byArray, 0, n);
                }
            } else {
                printWriter = httpServletResponse.getWriter();
                printWriter.print(JSON.toJSONString((Object)fileResp.outputObject));
            }
        }
        catch (Exception exception) {
            logger.error("outputFile error!" + fileResp.fileName, (Throwable)exception);
        }
        finally {
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                logger.error("outputFile error!" + fileResp.fileName, (Throwable)iOException);
            }
        }
    }

    private String validate(ProceedingJoinPoint proceedingJoinPoint) {
        String string = null;
        Object[] objectArray = proceedingJoinPoint.getArgs();
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                if (object instanceof MultipartFile) {
                    logger.debug("request arg file!");
                } else {
                    logger.debug("request arg:" + JSON.toJSONString((Object)object));
                }
                if (object instanceof ValidateModel && !StringUtil.isEmpty(string = ValidateUtil.validate(object))) break;
            }
        }
        return string;
    }

    private RestResp<String> dealException(Exception exception, Object object, Method method) throws Exception {
        logger.error(BasePairConsts.ERROR.toString(), (Throwable)exception);
        RestResp<String> restResp = new RestResp<String>();
        restResp.setPair(BasePairConsts.ERROR);
        restResp.result = exception.getMessage();
        return restResp;
    }

    private DefaultTransactionDefinition createTransactionDefinition(RestAnn restAnn) {
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setPropagationBehavior(restAnn.transPropagationBehavior());
        defaultTransactionDefinition.setIsolationLevel(restAnn.transIsolationLevel());
        defaultTransactionDefinition.setReadOnly(restAnn.transaction().equals((Object)Transaction.READ));
        defaultTransactionDefinition.setTimeout(600);
        return defaultTransactionDefinition;
    }
}

