/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.alibaba.fastjson.JSON;
import com.jsmframe.annotation.CacheAnn;
import com.jsmframe.annotation.CacheType;
import com.jsmframe.context.SpringContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;

public class CacheAop {
    private static Logger logger = LogUtil.log(CacheAop.class);
    private Cache ehQueryCache;
    private Cache ehEnternalCache;
    private JedisService jedisService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object = null;
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        CacheAnn cacheAnn = method.getAnnotation(CacheAnn.class);
        if (cacheAnn == null) {
            return proceedingJoinPoint.proceed();
        }
        Method method2 = method;
        synchronized (method2) {
            object = cacheAnn.cacheType().equals((Object)CacheType.EHCACHE) ? this.ehcache(proceedingJoinPoint, cacheAnn) : this.jedisCache(proceedingJoinPoint, cacheAnn);
        }
        return object;
    }

    private Object jedisCache(ProceedingJoinPoint proceedingJoinPoint, CacheAnn cacheAnn) throws Throwable {
        Object object;
        String string = cacheAnn.cacheKey();
        if (StringUtil.isEmpty(string)) {
            string = this.getKey(proceedingJoinPoint);
        }
        int n = cacheAnn.expireSeconds();
        String string2 = this.getJedisService().get(string);
        if (string2 == null) {
            object = proceedingJoinPoint.proceed();
            this.getJedisService().setex(string, n, JSON.toJSONString((Object)object));
            logger.debug("update jedis key: " + string);
        } else {
            Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
            Class<?> clazz = method.getReturnType();
            object = JSON.parseObject((String)string2, clazz);
        }
        return object;
    }

    private Object ehcache(ProceedingJoinPoint proceedingJoinPoint, CacheAnn cacheAnn) throws Throwable {
        Object object;
        String string = cacheAnn.cacheKey();
        if (StringUtil.isEmpty(string)) {
            string = this.getKey(proceedingJoinPoint);
        }
        if (cacheAnn.eternal()) {
            Element element = this.getEhEnternalCache().get((Serializable)((Object)string));
            if (element == null) {
                object = proceedingJoinPoint.proceed();
                this.getEhEnternalCache().put(new Element((Serializable)((Object)string), (Serializable)object));
                logger.debug("update eternalCache key: " + string);
            } else {
                object = element.getObjectValue();
            }
        } else {
            Element element = this.getEhQueryCache().get((Serializable)((Object)string));
            if (element == null) {
                object = proceedingJoinPoint.proceed();
                this.getEhQueryCache().put(new Element((Serializable)((Object)string), (Serializable)object));
                logger.debug("update cache key: " + string);
            } else {
                object = element.getObjectValue();
            }
        }
        return object;
    }

    private String getKey(ProceedingJoinPoint proceedingJoinPoint) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(proceedingJoinPoint.toString());
        for (Object object : proceedingJoinPoint.getArgs()) {
            stringBuilder.append("|").append(object.hashCode());
        }
        return stringBuilder.toString();
    }

    public Cache getEhQueryCache() {
        if (this.ehQueryCache == null) {
            this.ehQueryCache = (Cache)SpringContext.getBean("ehQueryCache");
        }
        return this.ehQueryCache;
    }

    public Cache getEhEnternalCache() {
        if (this.ehEnternalCache == null) {
            this.ehEnternalCache = (Cache)SpringContext.getBean("ehEnternalCache");
        }
        return this.ehEnternalCache;
    }

    public JedisService getJedisService() {
        if (this.jedisService == null) {
            this.jedisService = (JedisService)SpringContext.getBean("jedisService");
        }
        return this.jedisService;
    }
}

