package com.jsmframe.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;

public class ValidCodeUtil {
	private static Logger log = LogUtil.log(ValidCodeUtil.class);
    private Random random = new Random();
//    private String randString = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";//随机产生的字符串
    private String randString = "0123456789";//随机产生的字符串
    
    private String name = "validCode";//放到session中的key
    private int width = 80;//图片宽
    private int height = 26;//图片高
    private int lineSize = 40;//干扰线数量
    private int num = 4;//随机产生字符数量
    
    private String validCode;
    
    public String getValidCode() {
		return validCode;
	}
    
	public ValidCodeUtil(String name, int width, int height, int num) {
		super();
		if(!StringUtil.isEmpty(name)){
    		this.name = name;
    	}
    	if(width != 0){
    		this.width = width;
    	}
    	if(height != 0){
    		this.height = height;
    	}
    	if(num != 0){
    		this.num = num;
    	}
	}
	/*
     * 获得字体
     */
    private Font getFont(){
        return new Font("Fixedsys",Font.CENTER_BASELINE,18);
    }
    /*
     * 获得颜色
     */
    private Color getRandColor(int fc,int bc){
        if(fc > 255)
            fc = 255;
        if(bc > 255)
            bc = 255;
        int r = fc + random.nextInt(bc-fc-16);
        int g = fc + random.nextInt(bc-fc-14);
        int b = fc + random.nextInt(bc-fc-18);
        return new Color(r,g,b);
    }
    /**
     * 生成随机图片
     */
    public BufferedImage getImage(HttpSession session) {
    	//BufferedImage类是具有缓冲区的Image类,Image类是用于描述图像信息的类
    	BufferedImage image = new BufferedImage(this.width,this.height,BufferedImage.TYPE_INT_BGR);
    	Graphics g = image.getGraphics();//产生Image对象的Graphics对象,改对象可以在图像上进行各种绘制操作
    	g.fillRect(0, 0, this.width, this.height);
    	g.setFont(new Font("Times New Roman",Font.ROMAN_BASELINE,18));
    	g.setColor(getRandColor(110, 133));
    	//绘制干扰线
    	for(int i=0;i<=lineSize;i++){
    		drowLine(g);
    	}
    	//绘制随机字符
    	String randomString = "";
    	for(int i=1;i<=this.num;i++){
    		randomString=drowString(g,randomString,i);
    	}
    	session.removeAttribute(this.name);
    	session.setAttribute(this.name, randomString);
    	log.debug("validCode:"+randomString);
    	g.dispose();
    	return image;
    }
    
    public BufferedImage getImage() {
    	//BufferedImage类是具有缓冲区的Image类,Image类是用于描述图像信息的类
    	BufferedImage image = new BufferedImage(this.width,this.height,BufferedImage.TYPE_INT_BGR);
    	Graphics g = image.getGraphics();//产生Image对象的Graphics对象,改对象可以在图像上进行各种绘制操作
    	g.fillRect(0, 0, this.width, this.height);
    	g.setFont(new Font("Times New Roman",Font.ROMAN_BASELINE,18));
    	g.setColor(getRandColor(110, 133));
    	//绘制干扰线
    	for(int i=0;i<=lineSize;i++){
    		drowLine(g);
    	}
    	//绘制随机字符
    	String randomString = "";
    	for(int i=1;i<=this.num;i++){
    		randomString=drowString(g,randomString,i);
    	}
//    	session.removeAttribute(this.name);
//    	session.setAttribute(this.name, randomString);
    	validCode = randomString;
    	log.debug("validCode:"+randomString);
    	g.dispose();
    	return image;
    }
    /*
     * 绘制字符串
     */
    private String drowString(Graphics g,String randomString,int i){
        g.setFont(getFont());
        g.setColor(new Color(random.nextInt(101),random.nextInt(111),random.nextInt(121)));
        String rand = String.valueOf(getRandomString(random.nextInt(randString.length())));
        randomString +=rand;
        g.translate(random.nextInt(3), random.nextInt(3));
        g.drawString(rand, 13*i, 16);
        return randomString;
    }
    /*
     * 绘制干扰线
     */
    private void drowLine(Graphics g){
        int x = random.nextInt(width);
        int y = random.nextInt(height);
        int xl = random.nextInt(13);
        int yl = random.nextInt(15);
        g.drawLine(x, y, x+xl, y+yl);
    }
    /*
     * 获取随机的字符
     */
    public String getRandomString(int num){
        return String.valueOf(randString.charAt(num));
    }
}