package com.jsmframe.utils;

import org.slf4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

import com.jsmframe.context.SpringContext;

public class TransactionUtil {
	
	private static Logger logger = LogUtil.log(TransactionUtil.class);
	
	private static ThreadLocal<TransactionStatus> transTL = new ThreadLocal<TransactionStatus>();
	
	public static PlatformTransactionManager getTransactionManager(){
		return ((PlatformTransactionManager) SpringContext.getBean("transactionManager"));
	}
	
	public static PlatformTransactionManager getTransactionManager(String transManagerName){
		return ((PlatformTransactionManager) SpringContext.getBean(transManagerName));
	}
	
	public static void setTransactionStatus(TransactionStatus status){
		transTL.set(status);
	}
	
	public static TransactionStatus getTransactionStatus(){
		return transTL.get();
	}
	
	public static void removeTransactionStatus(){
		transTL.remove();
	}
	
	public static void setRollbackOnly(){
		TransactionStatus transactionStatus = transTL.get();
		if(transactionStatus == null){
			logger.error("setRollbackOnly transactionStatus is null.");
			return;
		}
		if(transactionStatus.isCompleted()){
			logger.error("setRollbackOnly transactionStatus is completed.");
			return;
		}
		transactionStatus.setRollbackOnly();
	}
	
	public static void commit(){
		PlatformTransactionManager tm = getTransactionManager();
		TransactionStatus transactionStatus = transTL.get();
		if(transactionStatus == null){
			logger.error("commit transactionStatus is null.");
			return;
		}
		if(transactionStatus.isCompleted()){
			logger.error("commit transactionStatus is completed.");
			return;
		}
		tm.commit(transactionStatus);
	}

}
