
package com.jsmframe.utils;

import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import com.alibaba.fastjson.JSON;
import com.jsmframe.context.ProjectContext;


public class StringUtil {
	
	private static Logger logger = LogUtil.log(StringUtil.class);
	
	private static final String CONSTS_STR = "QWERTYUPASDFGHJKZXCVBNM1234567890qwertyupasdfghjkzxcvbnm";
	
	public static String substr(String str,int beginIdx,int length){
	  if(isEmpty(str)){
		  return str;
	  }
	  if(str.length() <= beginIdx){
		  return null;
	  }
	  int endIdx = beginIdx+length;
	  if(endIdx > str.length()){
		  endIdx = str.length();
	  }
	  return str.substring(beginIdx, endIdx);
	}
	
	public static String extract(String regx,String str){
		Pattern p = Pattern.compile(regx);   
		Matcher m = p.matcher(str);       
		if(m.find()) {
			return m.group();
		}
		return null;
	}
	
	public static String extractNumber(String str){
		return extract(ProjectContext.get("regex.extract.number"),str);
	}
	
	public static Integer extractInteger(String str){
		String res = extractNumber(str);
		if(!StringUtil.isEmpty(res)){
			return Integer.valueOf(res);
		}
		return null;
	}
	
	public static Float extractFloat(String str){
		String res = extractNumber(str);
		if(!StringUtil.isEmpty(res)){
			return Float.valueOf(res);
		}
		return null;
	}
	
	public static Double extractDouble(String str){
		String res = extractNumber(str);
		if(!StringUtil.isEmpty(res)){
			return Double.valueOf(res);
		}
		return null;
	}
	

    /**
     * iso8859-1转化为utf-8编码
     * 
     * @param str
     * @return
     */
    public static String iso2utf(String str){
        String result = StringUtils.stripToEmpty(str);
        try {
            result = new String(result.getBytes("ISO-8859-1"), "UTF-8");
        } catch (UnsupportedEncodingException e) {
        	logger.error("iso2utf error!", e);
        }
        return result;
    }
    
    public static String trim(String str){
    	if(str == null){
    		return "";
    	}
    	return str.trim();
    }

    /**
     * @return 将java对象转化为json字符串
     */
    public static String toJson(Object data){
        try {
        	return JSON.toJSONString(data);
//        	return JSONUtil.serialize(data);
        } catch (Exception e) {
        	logger.error("toJson error!", e);
        	return null;
        }
    }

    public static String toUtf8String(String s){
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (c >= 0 && c <= 255) {
                sb.append(c);
            } else {
                byte[] b;
                try {
                    b = Character.toString(c).getBytes("utf-8");
                } catch (Exception ex) {
                    System.out.println(ex);
                    b = new byte[0];
                }
                for (int j = 0; j < b.length; j++) {
                    int k = b[j];
                    if (k < 0)
                        k += 256;
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                }
            }
        }
        return sb.toString();
    }

    public static boolean isEmpty(Object object){
    	if (object == null) {
    		return true;
    	} else {
    		return isEmpty(object.toString());
    	}
    }
    public static boolean isEmpty(String str){
        if (str == null) {
            return true;
        } else {
            return "".equals(str = str.trim()) ? true : false;
        }
    }

    public static Integer toInteger(Object obj){
    	return toInteger(toString(obj), 0);
    }
    
    public static Integer toInteger(String str){
    	return toInteger(str, 0);
    }
    
    public static Integer toInteger(String val,Integer defaultVal){
        try {
            return Integer.valueOf(trim(val));
        } catch (Exception e) {
        	logger.error("toInteger error, use defaultVal:{}",defaultVal);
    		return defaultVal;
        }
    }
    
    public static Float toFloat(String str){
    	return toFloat(str, 0f);
    }
    
    public static Float toFloat(String val,Float defaultVal){
    	try {
    		return Float.valueOf(trim(val));
    	} catch (Exception e) {
    		logger.error("toFloat error, use defaultVal:{}",defaultVal);
    		return defaultVal;
    	}
    }

    public static Long toLong(String str){
    	return toLong(str, 0L);
    }
    
    public static Long toLong(String val,Long defaultVal){
        try {
            return Long.valueOf(val);
        } catch (Exception e) {
        	logger.error("toLong error, use defaultVal:{}",defaultVal);
    		return defaultVal;
        }
    }

    public static Double toDouble(String str){
    	return toDouble(str, 0d);
    }
    
    public static Double toDouble(String val,Double defaultVal){
        try {
            return Double.valueOf(val);
        } catch (Exception e) {
        	logger.error("toDouble error, use defaultVal:{}",defaultVal);
    		return defaultVal;
        }
    }

    public static String toString(Object object){
        return object == null ? "" : object.toString().trim();
    }

    /**
     * 判断2个不为空并且要相等
     * 
     * @param source
     * @param target
     * @return
     */
    public static boolean notNullAndEquls(Object source, Object target){
        if (source == null || target == null)
            return false;
        return source.toString().equals(target.toString());
    }

	public static boolean isEmail(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.email"));
		}
		return false;
	}
	public static boolean isUrl(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.url"));
		}
		return false;
	}
	public static boolean isIdcard(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.idcard"));
		}
		return false;
	}
	public static boolean isTelNo(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.telno"));
		}
		return false;
	}
	public static boolean isMobNo(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.mobno"));
		}
		return false;
	}
	public static boolean isIpv4(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.ipv4"));
		}
		return false;
	}
	public static boolean isDate(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.date"));
		}
		return false;
	}
	public static boolean isDateTime(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.datetime"));
		}
		return false;
	}
	public static boolean isChinese(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.chinese"));
		}
		return false;
	}
	public static boolean isNumber(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.number"));
		}
		return false;
	}
	public static boolean isMoney(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.money"));
		}
		return false;
	}
	public static boolean isBankCard(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.bankcard"));
		}
		return false;
	}
	public static boolean isEnNum(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.ennum"));
		}
		return false;
	}
	public static boolean isAccount(String str) {
		if(str != null){
			return str.matches(ProjectContext.get("regex.valid.account"));
		}
		return false;
	}
	
	public static boolean isEquals(String orginStr,String destStr){
		if(orginStr == null){
			return destStr == null;
		}else{
			return orginStr.equals(destStr);
		}
	}

	public static Long yuanToFen(Double money) {
		
		return Double.valueOf(money*100).longValue();
	}
	
	public static Double fenToYuan(Long money) {
		return money/100.0;
	}

	public static String fill(Object data, int len) {
		String val = data.toString();
		if(val.length() >= len){
			return val;
		}
		StringBuilder sb = new StringBuilder(len);
		for(int i=0;i<len-val.length();i++){
			sb.append("0");
		}
		sb.append(val);
		return sb.toString();
	}
	
	public static int getByteLength(String str){
		if(str == null){
			return 0;
		}
		return str.getBytes().length;
	}
	
	public static String normalizeSQL(String line){
		if (line == null){
			return line;
		}
		return line.trim().replaceAll("\\s+", " ");
	}
	
	public static String trimCRLF(String line){
		if (line == null){
			return line;
		}
		return line.replaceAll("(\r|\n|\r\n)", " ");
	}
	
	public static String trimTab(String line){
		if (line == null){
			return line;
		}
		return line.replaceAll("(\t+)", " ");
	}

	public static String genRandomString(int length){
		StringBuilder sb = new StringBuilder(length);
		Random random = new Random();
		for (int i = 0; i < length; i++) {
			sb.append(CONSTS_STR.charAt(random.nextInt(CONSTS_STR.length())));
		}
		return sb.toString();
	}
	
	public static void main(String[] args) {
		System.out.println(genRandomString(5));
	}
}
