package com.jsmframe.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;

/**
 *@author longzl / @createOn 2011-8-29
 *@desc
 */
public class PropUtil {
	private static Logger logger = LogUtil.log(PropUtil.class);
	public static String get(String key,String propFile){
			File file = FileUtil.getResource(propFile);
			Properties prop = new Properties();
			InputStream is;
			String val = null;
			try {
				is = new FileInputStream(file);
				prop.load(is);
				val = prop.getProperty(key);
				is.close();
			} catch (IOException e) {
				logger.error("file property {} in {} error",key, propFile);
			}
			return val; 
	}
	
	public static Integer getAsInteger(String key,String propFile){
		try {
			String val = get(key, propFile);
			if(!StringUtil.isEmpty(val)){
				return Integer.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsInteter error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	
	public static Long getAsLong(String key,String propFile){
		try {
			String val = get(key, propFile);
			if(!StringUtil.isEmpty(val)){
				return Long.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsLong error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	

	public static Boolean getAsBoolean(String key,String propFile){
		try {
			String val = get(key, propFile);
			if(!StringUtil.isEmpty(val)){
				return Boolean.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsBoolean error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	
	public static Properties getProperties(String propFile){
		File file = FileUtil.getResource(propFile);
		Properties prop = new Properties();
		InputStream is;
		try {
			is = new FileInputStream(file);
			prop.load(is);
			is.close();
		} catch (IOException e) {
			logger.error("load properties error! file {}",propFile);
		}
		return prop; 
	}
}
