package com.jsmframe.utils;

import java.io.File;
import java.io.FileNotFoundException;

import org.slf4j.Logger;
import org.springframework.util.ResourceUtils;

import com.jsmframe.exception.BaseException;


/**
 *@author longzl / @createOn 2010-9-3
 *@desc
 */
public class FileUtil {
	private static Logger logger = LogUtil.log(FileUtil.class);
	public static File getResource(String filename) {
		try {
			return ResourceUtils.getFile("classpath:" + filename);
		} catch (FileNotFoundException e) {
			logger.warn("file {0} not found" ,filename);
			throw new BaseException("file not found：" + filename, e);
		}
	}
	public static File createNewFile(String filePath) {
		filePath = filePath.replace('\\', '/').trim();
		new File(filePath.substring(0, filePath.lastIndexOf('/'))).mkdirs();
		return new File(filePath);
	}
	public static File getFile(String filename){
		return new File(filename);
	}
}
