package com.jsmframe.swagger;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import com.jsmframe.context.ProjectContext;
import com.jsmframe.utils.StringUtil;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableWebMvc
@EnableSwagger2
@Configuration
public class SwaggerConfig extends WebMvcConfigurationSupport {

	private boolean swaggerEnable = ProjectContext.getAsBoolean("swagger.enable");

    @Bean
    public Docket createRestApi() {
    	List<Parameter> params = new ArrayList<Parameter>();
    	String headers = ProjectContext.get("swagger.apis.headers");
    	if(!StringUtil.isEmpty(headers)){
    		String[] headersArr = headers.split("\\|");
    		for(String header:headersArr){
    			String[] headeArr = header.split("-");
    			params.add(new Parameter(headeArr[0], "", headeArr[1], true, false, new ModelRef("String"), null, null, "header", null, false, null));
    		}
    	}
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .enable(swaggerEnable)
                .globalOperationParameters(params)
                .select()
                .apis(RequestHandlerSelectors.basePackage(ProjectContext.get("swagger.apis.pakcage")))
                .paths(PathSelectors.any())
                .build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title(ProjectContext.get("swagger.apis.title"))
                .version(ProjectContext.get("swagger.apis.version"))
                .description(ProjectContext.get("swagger.apis.description"))
                .build();
    }

}