package com.jsmframe.mybatis;

import java.util.regex.Matcher;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;

public class SqlServer2012Dialect extends AbstractDialect {

	@Override
	public String concatCountSql(String sql) {
		StringBuffer sb = new StringBuffer("select count(*) from ");
		Matcher fromMatcher = fromPattern.matcher(sql);
		int beginIndex = 0;
		if (fromMatcher.find()) {
			beginIndex = fromMatcher.end();
		}
		Matcher orderByMatcher = orderByPattern.matcher(sql);
		int lastIndex = sql.lastIndexOf(")");
		if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
			sb.append(sql.substring(beginIndex, orderByMatcher.start()));
		} else {
			sb.append(sql.substring(beginIndex));
		}
		return sb.toString();
	}

	@Override
	public String concatPageSql(String sql, int startRow, int pageSize) {
		StringBuilder sqlBuilder = new StringBuilder(sql.length() + 64);
        sqlBuilder.append(sql);
        sqlBuilder.append(" OFFSET ");
        sqlBuilder.append(startRow);
        sqlBuilder.append(" ROWS FETCH NEXT ");
        sqlBuilder.append(pageSize);
        sqlBuilder.append(" ROWS ONLY");
        return sqlBuilder.toString();
	}

	public SqlSource getSqlSource(BoundSql boundSql) {

		return new MySqlSource(boundSql);

	}

	public class MySqlSource implements SqlSource {
		BoundSql boundSql;

		public MySqlSource(BoundSql boundSql) {
			this.boundSql = boundSql;
		}

		@Override
		public BoundSql getBoundSql(Object parameterObject) {
			return boundSql;
		}
	}

}
