package com.jsmframe.mybatis;

import java.util.regex.Matcher;

public class MysqlDialect extends AbstractDialect {

	@Override
	public String concatCountSql(String sql) {
		StringBuffer sb = new StringBuffer("select count(*) from ");
		Matcher fromMatcher = fromPattern.matcher(sql);
		int beginIndex = 0;
		if (fromMatcher.find()) {
			beginIndex = fromMatcher.end();
		}
		Matcher orderByMatcher = orderByPattern.matcher(sql);
		int lastIndex = sql.lastIndexOf(")");
		if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
			sb.append(sql.substring(beginIndex, orderByMatcher.start()));
		} else {
			sb.append(sql.substring(beginIndex));
		}
		return sb.toString();
	}

	@Override
	public String concatPageSql(String sql, int startRow, int pageSize) {
		StringBuffer sb = new StringBuffer();
		sb.append(sql);
		sb.append(" limit ").append(startRow).append(" , ").append(pageSize);
		return sb.toString();
	}

}
