package com.jsmframe.mybatis;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.MappedStatement.Builder;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;

public abstract class AbstractDialect implements Dialect {
	
	protected static Pattern fromPattern = Pattern.compile("\\s+from\\s+",Pattern.CASE_INSENSITIVE);
	protected static Pattern orderByPattern = Pattern.compile("\\s+order\\s+by\\s+",Pattern.CASE_INSENSITIVE);
	
	protected Properties properties;
	
	public void setProperties(Properties properties) {
		this.properties = properties;
	} 
    
    /** 
     * 复制BoundSql对象 
     */  
    public BoundSql createNewBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {  
      BoundSql newBoundSql = new BoundSql(ms.getConfiguration(),sql, boundSql.getParameterMappings(), boundSql.getParameterObject());  
      for (ParameterMapping mapping : boundSql.getParameterMappings()) {  
          String prop = mapping.getProperty();  
          if (boundSql.hasAdditionalParameter(prop)) {  
              newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));  
          }  
      }  
      return newBoundSql;  
    }
    
    /** 
     * 复制BoundSql对象 
     */  
    public MappedStatement createNewMappedStatement(MappedStatement ms, BoundSql boundSql, String sql) {  
    	BoundSql newBoundSql = createNewBoundSql(ms, boundSql, sql);
    	return createNewMappedStatement(ms, getSqlSource(newBoundSql));  
//    	return createNewMappedStatement(ms, ms.getSqlSource());  
    }
    
    /** 
     * 复制MappedStatement对象 
     */  
    public MappedStatement createNewMappedStatement(MappedStatement ms,SqlSource newSqlSource) {  
      Builder builder = new Builder(ms.getConfiguration(),ms.getId(),newSqlSource,ms.getSqlCommandType());  
        
      builder.resource(ms.getResource());  
      builder.fetchSize(ms.getFetchSize());  
      builder.statementType(ms.getStatementType());  
      builder.keyGenerator(ms.getKeyGenerator());  
      if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
          StringBuilder keyProperties = new StringBuilder();
          for (String keyProperty : ms.getKeyProperties()) {
              keyProperties.append(keyProperty).append(",");
          }
          keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
          builder.keyProperty(keyProperties.toString());
      }  
      builder.timeout(ms.getTimeout());  
      builder.parameterMap(ms.getParameterMap());  
      builder.resultMaps(ms.getResultMaps());  
      builder.resultSetType(ms.getResultSetType());  
      builder.cache(ms.getCache());  
      builder.flushCacheRequired(ms.isFlushCacheRequired());  
      builder.useCache(ms.isUseCache());  
        
      return builder.build();  
    } 
    
	public String getSqlBody(String sql) {
		Matcher fromMatcher = fromPattern.matcher(sql);
		int beginIndex = 0;
		if (fromMatcher.find()) {
			beginIndex = fromMatcher.end();
		}
		return sql.substring(beginIndex);
	}
	
	public SqlSource getSqlSource(final BoundSql boundSql) {

		return new SqlSource() {
			
			@Override
			public BoundSql getBoundSql(Object parameterObject) {
				return boundSql;
			}
		};

	}
	
}
