package com.jsmframe.interceptor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;

import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;

import com.alibaba.fastjson.JSON;
import com.jsmframe.dao.model.Page;
import com.jsmframe.mybatis.Db2Dialect;
import com.jsmframe.mybatis.Dialect;
import com.jsmframe.mybatis.MysqlDialect;
import com.jsmframe.mybatis.OracleDialect;
import com.jsmframe.mybatis.SqlServer2012Dialect;
import com.jsmframe.mybatis.SqlServerDialect;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;


@Intercepts(
		{
	        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}),
	        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}),
	    }
	)
public class PageInterceptor implements Interceptor {
	
	private static Logger logger = LogUtil.log(PageInterceptor.class);
	private Dialect dialect = new MysqlDialect();
	private static final String MYSQL = "mysql";
	private static final String ORACLE = "oracle";
	private static final String DB2 = "oracle";
	private static final String SQLSERVER = "sqlserver";
	private static final String SQLSERVER2012 = "sqlserver2012";
	
	// 插件运行的代码，它将代替原有的方法
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		 //获取拦截方法的参数
        Object[] args = invocation.getArgs();
        logger.debug("query args:{}",args.length);
        MappedStatement ms = (MappedStatement) args[0];
        Object parameterObject = args[1];
//        RowBounds rowBounds = (RowBounds) args[2];
//        ResultHandler resultHandler = (ResultHandler) args[3];
//        Executor executor = (Executor) invocation.getTarget();
        BoundSql boundSql = null;
        if(args.length == 4){
        	//4 个参数时
//            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
            boundSql = ms.getBoundSql(parameterObject);
        } else {
        	//6 个参数时
//            cacheKey = (CacheKey) args[4];
            boundSql = (BoundSql) args[5];
        }
        
        // 分页参数作为参数对象parameterObject的一个属性  
        String sql = boundSql.getSql();
        
        if(boundSql.getParameterObject() instanceof  Page){
        	Page<?> page = (Page<?>)(boundSql.getParameterObject());
            String pageSql = null;
//            if(page.getTotalCount() == 0){
            	PreparedStatement countStmt = null;
            	Connection connection = null;
            	ResultSet rs = null;
            	String countSql = null;
            	int totalCount = 0;
            	try {
            		countSql = StringUtil.normalizeSQL(dialect.concatCountSql(sql));
            		logger.debug("countSql: {}", countSql);
            		pageSql = dialect.concatPageSql(sql,page.getBeginIndex(),page.getPageSize());
            		connection = ms.getConfiguration().getEnvironment().getDataSource().getConnection()  ;            
            		countStmt = connection.prepareStatement(countSql);    
            		BoundSql countBoundSql = dialect.createNewBoundSql(ms, boundSql, countSql);  
            		DefaultParameterHandler parameterHandler = new DefaultParameterHandler(ms, parameterObject, countBoundSql);  
            		parameterHandler.setParameters(countStmt);  
            		rs = countStmt.executeQuery();   
            		if (rs.next()) {  
            			totalCount = rs.getInt(1);  
            		}
            	} catch (Exception e) {  
            		logger.error("count records for page error!sql:"+sql,e);  
            	} finally {  
            		try {
            			if(rs != null){
            				rs.close();  
            			}
            			if(countStmt != null){
            				countStmt.close();  
            			}
            			if(connection != null){
            				connection.close();  
            			}
            		} catch (Exception e) {  
            			logger.error("count records for page close conn error!sql:"+sql, e);  
            		}  
            	}
            	page.setTotalCount(totalCount);
//            }
            
            MappedStatement newMs = dialect.createNewMappedStatement(ms, boundSql,pageSql);    
            invocation.getArgs()[0]= newMs;   
            Object list = invocation.proceed();
            page.setList((List)list);
            return list;
        }else{
        	return invocation.proceed();
        }
	}

	// 拦截类型StatementHandler ||ResultSetHandler
	@Override
	public Object plugin(Object target) {
        return Plugin.wrap(target, this);  
	}

	@Override
	public void setProperties(Properties properties) {
		logger.debug("properties:{}",JSON.toJSONString(properties));
		String dbDialect = properties.getProperty("dbDialect");
		if(MYSQL.equalsIgnoreCase(dbDialect)){
			this.dialect = new MysqlDialect();
		}else if(ORACLE.equalsIgnoreCase(dbDialect)){
			this.dialect = new OracleDialect();
		}else if(DB2.equalsIgnoreCase(dbDialect)){
			this.dialect = new Db2Dialect();
		}else if(SQLSERVER.equalsIgnoreCase(dbDialect)){
			this.dialect = new SqlServerDialect();
		}else if(SQLSERVER2012.equalsIgnoreCase(dbDialect)){
			this.dialect = new SqlServer2012Dialect();
		}else{
			logger.warn("dbDialect not specify, use default:mysql");
		}
		
	}
	
}