package com.jsmframe.interceptor;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.NestedServletException;

import com.jsmframe.context.WebContext;
import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.LogUtil;

/**
 *@author longzl / @createOn 2010-6-25
 *@desc
 */
public class JsmFilter extends OncePerRequestFilter {
	private Logger logger = LogUtil.log(this.getClass());

	private String encoding;

	private boolean forceEncoding = false;

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public void setForceEncoding(boolean forceEncoding) {
		this.forceEncoding = forceEncoding;
	}

	@Override
	protected void doFilterInternal(HttpServletRequest request,	HttpServletResponse response, FilterChain fc)
			throws ServletException, IOException {
		String reqMethod = request.getMethod();
		logger.debug(reqMethod + " "+request.getRequestURI());
		
		
		if ((this.encoding != null)
				&& (((this.forceEncoding) || (request.getCharacterEncoding() == null)))) {
			request.setCharacterEncoding(this.encoding);
			if (this.forceEncoding) {
				response.setCharacterEncoding(this.encoding);
			}
		}
		WebContext.setRequest(request);
		WebContext.setResponse(response);
		
		try {
			if(reqMethod.equals(RequestMethod.OPTIONS.name())){
				String error = "request method not support.";
				logger.warn("request method not support {}",reqMethod);
				WebContext.toErrorPage(error);
			}else{
				logger.debug("before fc.doFilter");
				fc.doFilter(request, response);// FileUploadBase$SizeLimitExceededException
				logger.debug("after fc.doFilter");
			}
		} catch (NestedServletException nse) {
			String error = "访问" + request.getRequestURL().toString() + "出错！";
			logger.error(error,nse);
			if (nse.getCause() instanceof BaseException) {
				WebContext.toErrorPage(nse.getCause().getMessage());
			} else if (nse.getCause() instanceof MaxUploadSizeExceededException) {
				WebContext.toErrorPage("文件大小超过限制！");
			} else {
				WebContext.toErrorPage("系统出错！");
			}
			logger.error(error, nse);
		} catch (Exception e) {
			String error = "访问" + request.getRequestURL().toString() + "出错！";
			logger.error(error,e);
			WebContext.toErrorPage(error);
		}
		
		WebContext.removeRequest();
		WebContext.removeResponse();
	}

}
