package com.jsmframe.context;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;

import org.slf4j.Logger;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;

public class ProjectContext {
	private static Logger logger = LogUtil.log(ProjectContext.class);
	private static boolean devModel = true;
	private static boolean jedisSession = false;
	private static String propFile = "project.properties";
	private static Properties properties;
	
	public static String get(String key){
		if(devModel || properties == null){
			properties = PropUtil.getProperties(propFile);
		}
		return properties.getProperty(key);
	}

	public static boolean isDevModel() {
		return devModel;
	}
	
	public static boolean isJedisSession() {
		return jedisSession;
	}

	public static Integer getAsInteger(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Integer.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsInteter error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	
	public static Long getAsLong(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Long.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsLong error! key {} in propFile {}", key,propFile);
			return null;
		}
	}

	public static Boolean getAsBoolean(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Boolean.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsBoolean error! key {} in propFile {}", key,propFile);
			return null;
		}
	}

	public static void init() {
		
		devModel = getAsBoolean("dev.model");
		jedisSession = getAsBoolean("jedis.session");
		logger.info("devModel:{}",devModel);
		logger.info("jedisSession:{}",jedisSession);
		Properties prop = System.getProperties(); 
		String httpProxyHost = properties.getProperty("http.proxyHost");
		String httpProxyPort = properties.getProperty("http.proxyPort");
		String httpNonProxyHosts = properties.getProperty("http.nonProxyHosts");
		String httpsProxyHost = properties.getProperty("https.proxyHost");
		String httpsProxyPort = properties.getProperty("https.proxyPort");
		String httpsNonProxyHosts = properties.getProperty("https.nonProxyHosts");
		String ftpProxyHost = properties.getProperty("ftp.proxyHost");
		String ftpProxyPort = properties.getProperty("ftp.proxyPort");
		String ftpNonProxyHosts = properties.getProperty("ftp.nonProxyHosts");
		String socksProxyHost = properties.getProperty("socks.proxyHost");
		String socksProxyPort = properties.getProperty("socks.proxyPort");
//		String socksNonProxyHosts = properties.getProperty("socks.nonProxyHosts");
		
		String proxyUsername = properties.getProperty("proxy.username");
		String proxyPassword = properties.getProperty("proxy.password");
		if(!StringUtil.isEmpty(httpProxyHost)){
			logger.info("http.proxyHost:{}",httpProxyHost);
			logger.info("http.proxyPort:{}",httpProxyPort);
			logger.info("http.nonProxyHosts:{}",httpNonProxyHosts);
			prop.setProperty("http.proxyHost", httpProxyHost);  
			prop.setProperty("http.proxyPort", httpProxyPort);  
			prop.setProperty("http.nonProxyHosts", httpNonProxyHosts);  
		}
		if(!StringUtil.isEmpty(httpsProxyHost)){
			logger.info("https.proxyHost:{}",httpsProxyHost);
			logger.info("https.proxyPort:{}",httpsProxyPort);
			logger.info("https.nonProxyHosts:{}",httpsNonProxyHosts);
			prop.setProperty("https.proxyHost", httpsProxyHost);  
			prop.setProperty("https.proxyPort", httpsProxyPort);  
			prop.setProperty("https.nonProxyHosts", httpsNonProxyHosts);  
		}
		if(!StringUtil.isEmpty(ftpProxyHost)){
			logger.info("ftp.proxyHost:{}",ftpProxyHost);
			logger.info("ftp.proxyPort:{}",ftpProxyPort);
			logger.info("ftp.nonProxyHosts:{}",ftpNonProxyHosts);
			prop.setProperty("ftp.proxyHost", ftpProxyHost);  
			prop.setProperty("ftp.proxyPort", ftpProxyPort);  
			prop.setProperty("ftp.nonProxyHosts", ftpNonProxyHosts);  
		}
		if(!StringUtil.isEmpty(socksProxyHost)){
			logger.info("socks.proxyHost:{}",socksProxyHost);
			logger.info("socks.proxyPort:{}",socksProxyPort);
			prop.setProperty("socksProxyHost", socksProxyHost);  
			prop.setProperty("socksProxyPort", socksProxyPort);  
		}
		if(!StringUtil.isEmpty(proxyUsername)){
			logger.info("proxy.username:{}",proxyUsername);
			final String username = proxyUsername;
			final String password = proxyPassword;
			Authenticator.setDefault(new Authenticator() {
				@Override
				protected PasswordAuthentication getPasswordAuthentication() {
					return new PasswordAuthentication(username, password.toCharArray());   
				}
				
			});
		}
	}
	
	
}
