package com.jsmframe.context;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.slf4j.Logger;

import com.jsmframe.service.JsmAppListenerService;
import com.jsmframe.utils.LogUtil;

/**
 *@author longzl / @createOn 2010-8-28
 *@desc 启动服务时 初始工作
 */
public class JsmInitListener implements ServletContextListener {
	private static Logger logger = LogUtil.log(JsmInitListener.class);
	
	// private static Dao dao;
	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class);
		if(appListenerService != null){
			appListenerService.close(sce);
		}
		logger.info("app close complete!");
	}

	@Override
	public void contextInitialized(ServletContextEvent sce) {
		WebContext.setContextPath(sce.getServletContext().getContextPath());// /ljdy
		WebContext.setRealPath(sce.getServletContext().getRealPath("/"));// d:/ljdy
		System.setProperty("file.encoding", "utf-8");
		ProjectContext.init();
		logger.info("jsm-frame init complete!");
		JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class);
		if(appListenerService != null){
			appListenerService.init(sce);
		}
		this.appContextInitialized(sce);
		logger.info("app init complete!");
		
		// 加载初始化数据
//		ScheduleTaskService sheduleTaskService = SpringContext.getBean(ScheduleTaskService.class);
//		sheduleTaskService.initSheduleJobs();
	}
	
	protected void appContextInitialized(ServletContextEvent sce) {
		
	}
	
}
