package com.jsmframe.context;

import java.util.Properties;

import org.slf4j.Logger;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;

public class AppContext {
	private static Logger logger = LogUtil.log(AppContext.class);
	private static String propFile = "app.properties";
	private static Properties properties;
	
	public static String get(String key){
		if(ProjectContext.isDevModel() || properties == null){
			properties = PropUtil.getProperties(propFile);
		}
		return properties.getProperty(key);
	}
	
	public static Integer getAsInteger(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Integer.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsInteter error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	
	public static Long getAsLong(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Long.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsLong error! key {} in propFile {}", key,propFile);
			return null;
		}
	}

	public static Boolean getAsBoolean(String key){
		try {
			String val = get(key);
			if(!StringUtil.isEmpty(val)){
				return Boolean.valueOf(val);
			}else{
				logger.error("key is empty, key {} in propFile {}", key,propFile);
				return null;
			}
		} catch (Exception e) {
			logger.error("getAsBoolean error! key {} in propFile {}", key,propFile);
			return null;
		}
	}
	
}
