package com.jsmframe.base;

import java.util.Date;

import org.slf4j.Logger;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

import com.jsmframe.interceptor.MyDateEditor;
import com.jsmframe.rest.resp.FileResp;
import com.jsmframe.utils.LogUtil;

@RestController
public class BaseRest {
	protected Logger logger = LogUtil.log(getClass());
	
	@InitBinder
    public void initBinder(WebDataBinder binder) {
		 binder.registerCustomEditor(Date.class, new MyDateEditor());
    }
	
	public FileResp fileResp(String fileName,Object object){
		FileResp fileResp = new FileResp();
		fileResp.fileName = fileName;
		fileResp.outputObject = object;
		return fileResp;
	}
	
}
