package com.jsmframe.annotation;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.transaction.TransactionDefinition;

/**
 *@author longzl / @createOn 2010-6-30
 *@desc
 */
@Target( { java.lang.annotation.ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface RestAnn {

	/** 是登录客户端类型，默认为APP 移动端	 */
	public abstract AuthType authType() default AuthType.NONE;
	
	/** 权限，默认值为"" PremissionCode or ResourceCode */
	public abstract String permission() default "";
	
	/** 日志组 */
	public abstract String logType() default "";
	
	/** 日志支持变量 */
	public abstract String log() default "";

	/** 是否需要验证 */
	public abstract boolean validate() default true;
	
	/** synchronized,默认并行请求 */
	public abstract boolean sync() default false;
	
	/** 事务只读属性，默认为true	 */
	public abstract Transaction transaction() default Transaction.WRITE;

	/** 传播行为 */
	public abstract int transPropagationBehavior() default TransactionDefinition.PROPAGATION_REQUIRED;
	
	/*** 隔离级别*/
	public abstract int transIsolationLevel() default TransactionDefinition.ISOLATION_DEFAULT;
	
	/**	自定事务管理器 */
	public abstract String transManagerName() default "";

}
