package com.jsmframe.annotation;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target( { java.lang.annotation.ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface FieldAnn {
	
	public boolean required() default true;
	
	public FieldType type() default FieldType.ALL;
	
	public String regex() default "";
	
	public String message() default "";
	
	/**
	 * 内置对象 vm(本身) session(JsmSession) request(HttpServletRequest)
	 * #{elvar}
	 * @return
	 */
	public String el() default "";
	
	/**
	 * 需要实现ValidateCallback接口
	 * com.*.ValidateClazz.method
	 * @return
	 */
	public String cb() default "";
	
	public int minLen() default -1;
	
	public int maxLen() default -1;
	
	public EscapeType escape() default EscapeType.ALL;
	
}
