package com.jsmframe.annotation;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author longzl / @createOn 2011-8-31
 * @desc cache the method's return value
 */
@Target({ java.lang.annotation.ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface CacheAnn {
	/**
	 * 缓存方式
	 */
	public CacheType cacheType() default CacheType.EHCACHE;
	
	/**
	 * 过期时间秒
	 * only support CacheType.REDIS
	 */
	public int expireSeconds() default 0;

	/** 
	 * 是否为永久缓存 默认为false 
	 *  only support CacheType.EHCACHE
	 * */
	public boolean eternal() default false;
	
	public String cacheKey() default "";
	
	
}
