/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.session;

import cn.ibaijia.isocket.session.Session;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static Map<String, Session<?>> sessionMap = new ConcurrentHashMap();
    private static Map<SocketChannel, Integer> waitEventMap = new ConcurrentHashMap<SocketChannel, Integer>();

    public static void status() {
        logger.info("sessionMap size:{},waitEventMap size:{}", (Object)sessionMap.size(), (Object)waitEventMap.size());
    }

    public static void put(Session<?> session) {
        sessionMap.put(session.getSessionID(), session);
    }

    public static Session<?> get(String sessionId) {
        return sessionMap.get(sessionId);
    }

    public static Session<?> get(SocketChannel channel) {
        String sessionId = SessionManager.genId(channel);
        return sessionMap.get(sessionId);
    }

    public static boolean close(String sessionId) {
        Session<?> session = sessionMap.remove(sessionId);
        if (session != null) {
            session.close();
            return true;
        }
        return false;
    }

    public static boolean close(SocketChannel channel) {
        String sessionId = SessionManager.genId(channel);
        Session<?> session = sessionMap.remove(sessionId);
        if (session != null) {
            waitEventMap.remove(session.getChannel());
            session.close();
            return true;
        }
        return false;
    }

    public static boolean close(Session<?> session) {
        if (session != null) {
            logger.info("session closing:{}", (Object)session.getSessionID());
            sessionMap.remove(session.getSessionID());
            waitEventMap.remove(session.getChannel());
            session.close();
            return true;
        }
        return false;
    }

    public static String genId(SocketChannel channel) {
        String sessionId = null;
        if (channel != null) {
            try {
                sessionId = channel.getLocalAddress() + "_" + channel.getRemoteAddress();
            }
            catch (Exception e) {
                logger.error("genId error.", (Throwable)e);
            }
        }
        return sessionId;
    }

    public static Map<SocketChannel, Integer> getWaitEventMap() {
        return waitEventMap;
    }
}

