/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.session;

import cn.ibaijia.isocket.Context;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.CompactBufferQueue;
import cn.ibaijia.isocket.session.SessionManager;
import cn.ibaijia.isocket.util.BufferUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session<T> {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private static final byte SESSION_STATUS_OPENED = 1;
    private static final byte SESSION_STATUS_CLOSING = 2;
    private static final byte SESSION_STATUS_CLOSED = 3;
    private String sessionId;
    private Context<T> context;
    private SocketChannel channel;
    private ByteBuffer readBuffer;
    private byte status = 1;
    private Object attachment;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private Queue<ByteBuffer> writeCacheQueue;
    private volatile boolean writeLocked = false;
    private volatile boolean readLocked = false;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public Session(SocketChannel channel, Context context) {
        this.channel = channel;
        this.context = context;
        try {
            this.sessionId = SessionManager.genId(channel);
            this.writeCacheQueue = context.isUseCompactQueue() ? (context.getCompactBuffSize() > 100 ? new CompactBufferQueue(context.getCompactBuffSize()) : new CompactBufferQueue()) : new ConcurrentLinkedQueue<ByteBuffer>();
            this.readBuffer = BufferUtil.allocate(context.getReadBuffSize(), context.isUseDirectBuffer());
            context.getSessionListener().onCreate(this);
        }
        catch (Exception e) {
            logger.error("create session error!", (Throwable)e);
        }
    }

    public void writeNext() {
        logger.debug("writeNext");
        if (this.status == 3) {
            logger.info("writeNext give up, session status:{}", (Object)this.status);
            return;
        }
        if (!this.writeCacheQueue.isEmpty()) {
            this.addReadWriteKey();
        } else {
            this.addReadKey();
        }
        this.check();
    }

    public void readNext() {
        logger.debug("readNext");
        if (this.status != 1) {
            logger.info("readNext give up, session status:{}", (Object)this.status);
            return;
        }
        if (!this.writeCacheQueue.isEmpty()) {
            this.addReadWriteKey();
        } else {
            this.addReadKey();
        }
    }

    private void check() {
        int cacheSize = this.writeCacheQueue.size();
        if (cacheSize > this.context.getWriteWarnLimit()) {
            this.context.getSessionListener().writeWarn(this, cacheSize);
        }
    }

    private void addWriteKey() {
        try {
            if (this.context.getSelector() == null) {
                SessionManager.close(this);
            }
            if (!this.isWriteLocked()) {
                logger.debug("addWriteKey");
                this.context.setSelectionKey(this.channel, 4);
            }
        }
        catch (Exception e) {
            logger.error("addWriteKey error!", (Throwable)e);
        }
    }

    private void addReadKey() {
        try {
            if (this.context.getSelector() == null) {
                SessionManager.close(this);
            }
            if (!this.isReadLocked()) {
                logger.debug("addReadKey");
                this.context.setSelectionKey(this.channel, 1);
            }
        }
        catch (Exception e) {
            logger.error("addReadKey error!", (Throwable)e);
        }
    }

    private void addReadWriteKey() {
        try {
            if (this.context.getSelector() == null) {
                SessionManager.close(this);
            }
            if (!this.isReadLocked()) {
                logger.debug("addReadWriteKey");
                this.context.setSelectionKey(this.channel, 5);
            }
        }
        catch (Exception e) {
            logger.error("addReadWriteKey error!", (Throwable)e);
        }
    }

    private void write(ByteBuffer buffer) {
        buffer.flip();
        this.writeCacheQueue.add(buffer);
        this.addWriteKey();
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean immediate) {
        if (this.channel == null) {
            return;
        }
        this.status = (byte)(immediate ? 3 : 2);
        if (immediate) {
            try {
                this.channel.shutdownInput();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException e) {
                logger.error("close session exception", (Throwable)e);
            }
            this.context.getSessionListener().closed(this);
        } else if (this.writeCacheQueue.size() == 0) {
            this.close(true);
            this.context.getSessionListener().closed(this);
        } else {
            this.context.getSessionListener().closing(this);
        }
    }

    public void processReadBuffer() {
        this.readWriteLock.readLock().lock();
        try {
            int readLength = this.channel.read(this.readBuffer);
            logger.debug("read length:{}", (Object)readLength);
            this.context.getSessionListener().readComplete(this, readLength);
            if (readLength == -1) {
                logger.info("session:{} read complete.length:{}", (Object)this.getSessionID(), (Object)readLength);
                SessionManager.close(this);
            } else if (readLength > 0) {
                this.readBuffer.flip();
                while (true) {
                    Object dataEntry;
                    if ((dataEntry = this.decode(this.readBuffer)) == null) break;
                    try {
                        this.context.getSessionListener().beforeProcess(this, dataEntry);
                        boolean success = this.context.getProcessor().process(this, dataEntry);
                        this.context.getSessionListener().afterProcess(this, dataEntry);
                        if (success) {
                            this.context.getSessionListener().processSuccess(this, dataEntry);
                            continue;
                        }
                        this.context.getSessionListener().processFailed(this, dataEntry, null);
                    }
                    catch (Exception e) {
                        this.context.getSessionListener().processFailed(this, dataEntry, e);
                    }
                }
                logger.debug("break decode.");
                if (this.status == 2) {
                    this.close(false);
                    return;
                }
                if (this.status == 3) {
                    return;
                }
                if (this.readBuffer.remaining() == 0) {
                    this.readBuffer.clear();
                } else if (this.readBuffer.position() > 0) {
                    this.readBuffer.compact();
                } else {
                    this.readBuffer.position(this.readBuffer.limit());
                    this.readBuffer.limit(this.readBuffer.capacity());
                }
            }
        }
        catch (Exception e) {
            logger.error("nio read fail:", (Throwable)e);
            this.context.getSessionListener().readFailed(this, this.readBuffer, e);
            SessionManager.close(this);
        }
        this.readWriteLock.readLock().unlock();
    }

    private Object decode(ByteBuffer readBuffer) {
        List<Protocol> protocolList = this.context.getProtocolList();
        ByteBuffer inputData = readBuffer;
        for (int i = protocolList.size() - 1; i >= 0; --i) {
            inputData = protocolList.get(i).decode(inputData, this);
        }
        return inputData;
    }

    private ByteBuffer encode(Object object) {
        List<Protocol> protocolList = this.context.getProtocolList();
        Object outputData = object;
        for (int i = 0; i < protocolList.size(); ++i) {
            outputData = protocolList.get(i).encode(outputData, this);
        }
        if (outputData instanceof ByteBuffer) {
            return (ByteBuffer)outputData;
        }
        logger.error("protocol not encode to ByteBuffer,please check protocol chain.");
        SessionManager.close(this);
        return null;
    }

    public void write(Object t) {
        this.write(this.encode(t));
    }

    public String getSessionID() {
        return this.sessionId;
    }

    public Context<T> getContext() {
        return this.context;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public <T> void setAttachment(T attachment) {
        this.attachment = attachment;
        logger.info("setAttachment:{}", attachment.getClass());
    }

    public SocketAddress getLocalAddress() {
        if (this.localAddress == null && this.channel != null) {
            try {
                this.localAddress = this.channel.getLocalAddress();
            }
            catch (IOException e) {
                logger.error("getLocalAddress error!", (Throwable)e);
            }
        }
        return this.localAddress;
    }

    public SocketAddress getRemoteAddress() {
        if (this.remoteAddress == null && this.channel != null) {
            try {
                this.remoteAddress = this.channel.getRemoteAddress();
            }
            catch (IOException e) {
                logger.error("getRemoteAddress error!", (Throwable)e);
            }
        }
        return this.remoteAddress;
    }

    public void writeBuffer() {
        this.readWriteLock.writeLock().lock();
        if (!this.writeCacheQueue.isEmpty()) {
            ByteBuffer byteBuffer = this.writeCacheQueue.peek();
            try {
                int result = this.channel.write(byteBuffer);
                logger.debug("pos:" + byteBuffer.position() + " limit:" + byteBuffer.limit() + " result:" + result + " remain:" + byteBuffer.remaining());
                if (!byteBuffer.hasRemaining()) {
                    this.writeCacheQueue.poll();
                    logger.debug("write completed:{}", (Object)result);
                    this.context.getSessionListener().writeComplete(this, result);
                } else {
                    logger.info("send:" + result);
                }
            }
            catch (Exception e) {
                logger.error("writeFailed error!", (Throwable)e);
                this.context.getSessionListener().writeFailed(this, byteBuffer, e);
                SessionManager.close(this);
            }
        }
        this.readWriteLock.writeLock().unlock();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized boolean isWriteLocked() {
        return this.writeLocked;
    }

    public synchronized void setWriteLocked(boolean writeLocked) {
        this.writeLocked = writeLocked;
    }

    public synchronized boolean isReadLocked() {
        return this.readLocked;
    }

    public synchronized void setReadLocked(boolean readLocked) {
        this.readLocked = readLocked;
    }
}

