/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.session;

import cn.ibaijia.isocket.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactBufferQueue
implements Queue<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(CompactBufferQueue.class);
    private Queue<ByteBuffer> queue = new LinkedList<ByteBuffer>();
    private volatile int size = 0;
    private int bufferSize = 262144;
    private ReentrantLock lock = new ReentrantLock();

    public CompactBufferQueue() {
    }

    public CompactBufferQueue(int bufferSize) {
        if (bufferSize > 100) {
            this.bufferSize = bufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer poll() {
        try {
            ByteBuffer buffer;
            this.lock.lock();
            if (this.queue.isEmpty()) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
            int length = 0;
            while ((buffer = this.queue.peek()) != null) {
                if (length == 0 && buffer.capacity() > this.bufferSize) {
                    this.queue.poll();
                    --this.size;
                    length += buffer.capacity();
                    list.add(buffer);
                    break;
                }
                if (buffer.capacity() + length >= this.bufferSize) break;
                this.queue.poll();
                --this.size;
                length += buffer.capacity();
                list.add(buffer);
            }
            ByteBuffer byteBuffer = length == 0 ? null : BufferUtil.merge(length, list);
            return byteBuffer;
        }
        catch (Exception e) {
            logger.error("poll error.", (Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ByteBuffer element() {
        try {
            this.lock.lock();
            ByteBuffer byteBuffer = this.queue.element();
            return byteBuffer;
        }
        catch (Exception e) {
            logger.error("element error.", (Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ByteBuffer peek() {
        try {
            this.lock.lock();
            ByteBuffer byteBuffer = this.queue.peek();
            return byteBuffer;
        }
        catch (Exception e) {
            logger.error("peek error.", (Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        catch (Exception e) {
            logger.error("isEmpty error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        try {
            this.lock.lock();
            boolean bl = this.queue.contains(o);
            return bl;
        }
        catch (Exception e) {
            logger.error("contains error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        try {
            this.lock.lock();
            Iterator<ByteBuffer> iterator = this.queue.iterator();
            return iterator;
        }
        catch (Exception e) {
            logger.error("contains error.", (Throwable)e);
            Iterator<ByteBuffer> iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            this.lock.lock();
            Object[] objectArray = this.queue.toArray();
            return objectArray;
        }
        catch (Exception e) {
            logger.error("toArray error.", (Throwable)e);
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.lock();
            T[] TArray = this.queue.toArray(a);
            return TArray;
        }
        catch (Exception e) {
            logger.error("toArray error.", (Throwable)e);
            T[] TArray = null;
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ByteBuffer byteBuffer) {
        try {
            this.lock.lock();
            ++this.size;
            boolean bl = this.queue.add(byteBuffer);
            return bl;
        }
        catch (Exception e) {
            logger.error("add error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        try {
            this.lock.lock();
            boolean bl = this.queue.remove(o);
            return bl;
        }
        catch (Exception e) {
            logger.error("remove error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.queue.containsAll(c);
            return bl;
        }
        catch (Exception e) {
            logger.error("containsAll error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends ByteBuffer> c) {
        try {
            this.lock.lock();
            boolean bl = this.queue.addAll(c);
            return bl;
        }
        catch (Exception e) {
            logger.error("addAll error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.queue.removeAll(c);
            return bl;
        }
        catch (Exception e) {
            logger.error("removeAll error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.queue.retainAll(c);
            return bl;
        }
        catch (Exception e) {
            logger.error("retainAll error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.queue.clear();
        }
        catch (Exception e) {
            logger.error("clear error.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(ByteBuffer byteBuffer) {
        try {
            this.lock.lock();
            boolean bl = this.queue.offer(byteBuffer);
            return bl;
        }
        catch (Exception e) {
            logger.error("offer error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ByteBuffer remove() {
        try {
            this.lock.lock();
            ByteBuffer byteBuffer = this.queue.remove();
            return byteBuffer;
        }
        catch (Exception e) {
            logger.error("remove error.", (Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = this.size;
            return n;
        }
        catch (Exception e) {
            logger.error("size error.", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

