/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.protocol;

import cn.ibaijia.isocket.protocol.LenType;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixLengthStringProtocol
implements Protocol<ByteBuffer, String> {
    private static final Logger logger = LoggerFactory.getLogger(FixLengthStringProtocol.class);
    private int HEAD_LENGTH = 4;
    private Byte endFlag = 10;
    private Charset charset = StandardCharsets.UTF_8;

    public FixLengthStringProtocol() {
        if (this.endFlag != null) {
            ++this.HEAD_LENGTH;
        }
    }

    public FixLengthStringProtocol(Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            ++this.HEAD_LENGTH;
        }
    }

    public FixLengthStringProtocol(LenType lenType, Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            ++this.HEAD_LENGTH;
        }
    }

    @Override
    public String decode(ByteBuffer readBuffer, Session session) {
        byte exceptFlag;
        logger.debug("decode");
        if (readBuffer.remaining() < this.HEAD_LENGTH) {
            logger.debug("remaining length:{} < intLen:{}", (Object)readBuffer.remaining(), (Object)this.HEAD_LENGTH);
            return null;
        }
        readBuffer.mark();
        int len = readBuffer.getInt() - this.HEAD_LENGTH;
        if (readBuffer.remaining() < len) {
            logger.debug("remaining length:{} < msgLen:{}", (Object)readBuffer.remaining(), (Object)len);
            readBuffer.reset();
            return null;
        }
        byte[] bytes = new byte[len];
        readBuffer.get(bytes);
        if (this.endFlag != null && (exceptFlag = readBuffer.get()) != this.endFlag) {
            logger.error("exceptFlag:{} != endFlag:{}, end flag error,make sure you get the string protocol!", (Object)exceptFlag, (Object)this.endFlag);
            SessionManager.close(session);
            return null;
        }
        String strData = null;
        try {
            strData = new String(bytes, this.charset);
        }
        catch (Exception e) {
            logger.error("bytes to String error,charset:" + this.charset, (Throwable)e);
            SessionManager.close(session);
        }
        return strData;
    }

    @Override
    public ByteBuffer encode(String object, Session session) {
        logger.debug("encode");
        byte[] bytes = new byte[]{};
        try {
            bytes = object.getBytes(this.charset);
        }
        catch (Exception e) {
            logger.error("String to bytes error,charset:" + this.charset, (Throwable)e);
            SessionManager.close(session);
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.HEAD_LENGTH + bytes.length);
        buffer.putInt(this.HEAD_LENGTH + bytes.length);
        buffer.put(bytes);
        if (this.endFlag != null) {
            buffer.put(this.endFlag);
        }
        return buffer;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

