/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.protocol;

import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import cn.ibaijia.isocket.util.BufferUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixLengthBufferProtocol
implements Protocol<ByteBuffer, ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(FixLengthBufferProtocol.class);
    private short HEAD_LENGTH = (short)4;
    private Byte endFlag = 10;

    public FixLengthBufferProtocol() {
        if (this.endFlag != null) {
            this.HEAD_LENGTH = (short)(this.HEAD_LENGTH + 1);
        }
    }

    public FixLengthBufferProtocol(Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            this.HEAD_LENGTH = (short)(this.HEAD_LENGTH + 1);
        }
    }

    @Override
    public ByteBuffer decode(ByteBuffer readBuffer, Session session) {
        byte exceptFlag;
        logger.debug("decode");
        if (readBuffer.remaining() < this.HEAD_LENGTH) {
            logger.debug("remaining length:{} < HEAD_LENGTH:{}", (Object)readBuffer.remaining(), (Object)this.HEAD_LENGTH);
            return null;
        }
        readBuffer.mark();
        int len = readBuffer.getInt() - this.HEAD_LENGTH;
        if (readBuffer.remaining() < len) {
            logger.debug("remaining length:{} < msgLen:{}", (Object)readBuffer.remaining(), (Object)len);
            readBuffer.reset();
            return null;
        }
        byte[] bytes = new byte[len];
        readBuffer.get(bytes);
        if (this.endFlag != null && (exceptFlag = readBuffer.get()) != this.endFlag) {
            logger.error("exceptFlag:{} != endFlag:{}, end flag error,make sure you get the buffer protocol!", (Object)exceptFlag, (Object)this.endFlag);
            SessionManager.close(session);
            return null;
        }
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public ByteBuffer encode(ByteBuffer bufferData, Session session) {
        logger.debug("encode");
        int length = this.HEAD_LENGTH + bufferData.capacity();
        ByteBuffer buffer = BufferUtil.allocate(length, bufferData.isDirect());
        buffer.putInt(length);
        buffer.put(bufferData);
        if (this.endFlag != null) {
            buffer.put(this.endFlag);
        }
        return buffer;
    }
}

