/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.protocol;

import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import cn.ibaijia.isocket.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixLengthBigBufferProtocol<B extends Buffer>
implements Protocol<ByteBuffer, ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(FixLengthBigBufferProtocol.class);
    private short HEAD_LENGTH = (short)4;
    private Byte endFlag = 10;
    private ByteBuffer bigBuffer = null;
    private boolean decodeNew = true;

    public FixLengthBigBufferProtocol() {
        if (this.endFlag != null) {
            this.HEAD_LENGTH = (short)(this.HEAD_LENGTH + 1);
        }
    }

    public FixLengthBigBufferProtocol(Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            this.HEAD_LENGTH = (short)(this.HEAD_LENGTH + 1);
        }
    }

    @Override
    public ByteBuffer decode(ByteBuffer readBuffer, Session session) {
        logger.debug("decode");
        if (readBuffer.remaining() == 0) {
            return null;
        }
        if (this.decodeNew) {
            this.decodeNew = false;
            if (readBuffer.remaining() < this.HEAD_LENGTH) {
                logger.debug("remaining length:{} < HEAD_LENGTH:{}", (Object)readBuffer.remaining(), (Object)this.HEAD_LENGTH);
                return null;
            }
            BufferUtil.free(this.bigBuffer);
            int len = readBuffer.getInt() - this.HEAD_LENGTH;
            this.bigBuffer = BufferUtil.allocate(len, session.getContext().isUseDirectBuffer());
        }
        int readLen = this.bigBuffer.remaining();
        if (readBuffer.remaining() < this.bigBuffer.remaining()) {
            readLen = readBuffer.remaining();
        }
        byte[] bytes = new byte[readLen];
        readBuffer.get(bytes);
        this.bigBuffer.put(bytes);
        if (this.bigBuffer.remaining() == 0) {
            byte exceptFlag;
            if (this.endFlag != null && (exceptFlag = readBuffer.get()) != this.endFlag) {
                logger.error("exceptFlag:{} != endFlag:{}, end flag error,make sure you get the big buffer protocol!", (Object)exceptFlag, (Object)this.endFlag);
                SessionManager.close(session);
                return null;
            }
            this.decodeNew = true;
            return this.bigBuffer;
        }
        this.decodeNew = false;
        return null;
    }

    @Override
    public ByteBuffer encode(ByteBuffer object, Session session) {
        logger.debug("encode");
        if (object == null) {
            return null;
        }
        int length = this.HEAD_LENGTH + object.capacity();
        ByteBuffer buffer = BufferUtil.allocate(length, object.isDirect());
        buffer.putInt(length);
        buffer.put(object);
        if (this.endFlag != null) {
            buffer.put(this.endFlag);
        }
        return buffer;
    }
}

