/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket.handler;

import cn.ibaijia.isocket.Context;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptCompletionHandler<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AcceptCompletionHandler.class);
    private Context<T> context;
    private SocketChannel socketChannel;

    public AcceptCompletionHandler(Context<T> context, SocketChannel socketChannel) {
        this.context = context;
        this.socketChannel = socketChannel;
    }

    @Override
    public void run() {
        this.createSession(this.socketChannel);
    }

    private void createSession(SocketChannel channel) {
        String remote = this.getRemoteAddress(channel);
        logger.info("nio server createSession:{}", (Object)remote);
        if (remote == null) {
            logger.error("can't get remote address, abort.");
            return;
        }
        Session session = new Session(channel, this.context);
        SessionManager.put(session);
        this.context.setSelectionKey(this.socketChannel, 1);
    }

    private String getRemoteAddress(SocketChannel channel) {
        try {
            return channel.getRemoteAddress().toString();
        }
        catch (Exception e) {
            logger.error("getRemoteAddress error!", (Throwable)e);
            return null;
        }
    }
}

