/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket;

import cn.ibaijia.isocket.Context;
import cn.ibaijia.isocket.handler.AcceptCompletionHandler;
import cn.ibaijia.isocket.handler.ReadCompletionHandler;
import cn.ibaijia.isocket.handler.WriteCompletionHandler;
import cn.ibaijia.isocket.processor.Processor;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server<T>
extends Context
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private Map<SocketOption<Object>, Object> options = new HashMap<SocketOption<Object>, Object>();
    private String host;
    private int port;
    private int backlog = 1000;
    private ServerSocketChannel serverSocketChannel = null;
    private ExecutorService executorService = null;

    public Server(String host, int port, Protocol protocol, Processor<T> processor) {
        this.host = host;
        this.port = port;
        this.addProtocol(protocol);
        this.processor = processor;
    }

    public Server(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        if (this.protocolList.isEmpty() || this.processor == null) {
            logger.error("protocol or processor can't be empty");
            return;
        }
        this.startInfo();
        logger.info("start server host:{},port:{},threads:{}", new Object[]{this.host, this.port, this.threadNumber});
        try {
            this.executorService = Executors.newFixedThreadPool(this.threadNumber, new ThreadFactory(){
                byte index = 0;

                @Override
                public Thread newThread(Runnable runnable) {
                    this.index = (byte)(this.index + 1);
                    return new Thread(runnable, "is-nio-s" + this.index);
                }
            });
            this.executorService.execute(this);
        }
        catch (Exception e) {
            logger.error("server start error!", (Throwable)e);
            this.shutdown();
        }
    }

    @Override
    public void run() {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            if (!this.options.isEmpty()) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.options.entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            if (this.host != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.host, this.port), this.backlog);
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.port), this.backlog);
            }
            this.selector = Selector.open();
            this.acceptAndProcess();
        }
        catch (Exception e) {
            logger.error("server run error!", (Throwable)e);
            this.shutdown();
        }
    }

    private void acceptAndProcess() {
        try {
            this.serverSocketChannel.register(this.selector, 16);
            while (true) {
                logger.debug("select!");
                this.selector.select();
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                logger.debug("key size:" + readyKeys.size());
                Iterator<SelectionKey> it = readyKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    if (key.isAcceptable()) {
                        this.processAcceptKey(key);
                        this.serverSocketChannel.register(this.selector, 16);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.processReadKey(key);
                        continue;
                    }
                    if (key.isWritable()) {
                        this.processWriteKey(key);
                        continue;
                    }
                    if (!key.isValid()) continue;
                    logger.debug("key isValid");
                    SocketChannel socketChannel = (SocketChannel)key.channel();
                    SessionManager.close(socketChannel);
                }
                this.regEvent();
            }
        }
        catch (Exception e) {
            logger.error("unknown error!", (Throwable)e);
            this.shutdown();
            return;
        }
    }

    private void processWriteKey(SelectionKey key) throws IOException {
        block5: {
            logger.debug("key isWritable");
            SocketChannel socketChannel = (SocketChannel)key.channel();
            Session<?> session = null;
            try {
                socketChannel.configureBlocking(false);
                session = SessionManager.get(socketChannel);
                if (session != null) {
                    if (!session.isWriteLocked()) {
                        session.setWriteLocked(true);
                        this.executorService.execute(new WriteCompletionHandler(session, socketChannel));
                    } else {
                        logger.debug("isWriteLocked");
                    }
                }
            }
            catch (Exception e) {
                logger.error("processWriteKey error", (Throwable)e);
                if (session == null) break block5;
                SessionManager.close(session);
            }
        }
    }

    private void processReadKey(SelectionKey key) {
        block6: {
            logger.debug("key isReadable");
            SocketChannel socketChannel = (SocketChannel)key.channel();
            if (socketChannel == null) {
                return;
            }
            Session<?> session = null;
            try {
                socketChannel.configureBlocking(false);
                session = SessionManager.get(socketChannel);
                if (session != null) {
                    if (!session.isReadLocked()) {
                        session.setReadLocked(true);
                        this.executorService.execute(new ReadCompletionHandler(session, socketChannel));
                    } else {
                        logger.debug("isReadLocked");
                    }
                }
            }
            catch (Exception e) {
                logger.error("processReadKey error", (Throwable)e);
                if (session == null) break block6;
                SessionManager.close(session);
            }
        }
    }

    private void processAcceptKey(SelectionKey key) {
        try {
            this.serverSocketChannel = (ServerSocketChannel)key.channel();
            SocketChannel socketChannel = this.serverSocketChannel.accept().socket().getChannel();
            socketChannel.configureBlocking(false);
            logger.debug("key isAcceptable");
            if (this.isBlackList(socketChannel)) {
                return;
            }
            if (socketChannel.isConnectionPending()) {
                socketChannel.finishConnect();
            }
            this.executorService.execute(new AcceptCompletionHandler(this, socketChannel));
        }
        catch (Exception e) {
            logger.error("processAcceptKey error", (Throwable)e);
        }
    }

    private boolean isBlackList(SocketChannel channel) {
        Set<String> blackList = this.getBlackList();
        if (blackList == null || blackList.isEmpty()) {
            return false;
        }
        try {
            String remoteIp = ((InetSocketAddress)channel.getRemoteAddress()).getHostName();
            boolean res = blackList.contains(remoteIp);
            logger.debug("remoteIp:{} is in blackList:{}", (Object)remoteIp, (Object)res);
            return res;
        }
        catch (Exception e) {
            logger.error("check isBlackList error.", (Throwable)e);
            return false;
        }
    }

    private void startInfo() {
        logger.info("Server StartInfo host:{} port:{} ", (Object)this.host, (Object)this.port);
        logger.info("protocol:{} ", (Object)this.protocolList.size());
        logger.info("processor:{} ", this.processor.getClass());
        logger.info("sessionListener:{} ", this.sessionListener.getClass());
        logger.info("readBuffSize:{} ", (Object)this.readBuffSize);
        logger.info("useCompactQueue:{},compactBuffSize:{}", (Object)this.useCompactQueue, (Object)this.compactBuffSize);
    }

    public void shutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }
        catch (IOException e) {
            logger.error("serverSocketChannel close error!", (Throwable)e);
        }
    }

    public Server<T> setOption(SocketOption name, Object value) {
        this.options.put(name, value);
        return this;
    }

    public Server<T> setThreadNumber(int threadNumber) {
        if (threadNumber > 1) {
            this.threadNumber = threadNumber;
        }
        return this;
    }

    public Server<T> setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
        return this;
    }

    public Server<T> setReadBuffSize(int readBuffSize) {
        if (readBuffSize > 4) {
            this.readBuffSize = readBuffSize;
        }
        return this;
    }

    public Server<T> setUseCompactQueue(boolean useCompactQueue) {
        this.useCompactQueue = useCompactQueue;
        return this;
    }

    public Server<T> setCompactBuffSize(int compactBuffSize) {
        this.compactBuffSize = compactBuffSize;
        return this;
    }

    public Server<T> setUseDirectBuffer(boolean useDirectBuffer) {
        this.useDirectBuffer = useDirectBuffer;
        return this;
    }

    public Server<T> setWriteWarnLimit(int writeWarnLimit) {
        this.writeWarnLimit = writeWarnLimit;
        return this;
    }
}

