/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket;

import cn.ibaijia.isocket.listener.DefaultSessionListener;
import cn.ibaijia.isocket.listener.SessionListener;
import cn.ibaijia.isocket.processor.Processor;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.SessionManager;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Context<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Protocol> protocolList = new ArrayList<Protocol>();
    protected Processor<T> processor;
    protected SessionListener sessionListener = new DefaultSessionListener();
    protected int threadNumber = 2;
    protected int readBuffSize = 262144;
    protected boolean useCompactQueue = false;
    protected int compactBuffSize = 102400;
    protected boolean useDirectBuffer = false;
    protected int writeWarnLimit = 500;
    protected Set<String> blackList;
    protected Selector selector = null;
    protected int selectionKey = 1;
    protected Object regLock = new Object();

    public List<Protocol> getProtocolList() {
        return this.protocolList;
    }

    public Context addProtocol(Protocol protocol) {
        this.protocolList.add(protocol);
        return this;
    }

    public void setProcessor(Processor<T> processor) {
        this.processor = processor;
    }

    public Processor<T> getProcessor() {
        return this.processor;
    }

    public SessionListener getSessionListener() {
        return this.sessionListener;
    }

    public Context<?> setSessionListener(SessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public int getReadBuffSize() {
        return this.readBuffSize;
    }

    public boolean isUseCompactQueue() {
        return this.useCompactQueue;
    }

    public int getCompactBuffSize() {
        return this.compactBuffSize;
    }

    public boolean isUseDirectBuffer() {
        return this.useDirectBuffer;
    }

    public int getWriteWarnLimit() {
        return this.writeWarnLimit;
    }

    public Set<String> getBlackList() {
        return this.blackList;
    }

    public void setBlackList(Set<String> blackList) {
        this.blackList = blackList;
    }

    public Selector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionKey(SocketChannel socketChannel, Integer selectionKey) {
        this.logger.debug("setSelectionKey begin");
        Object object = this.regLock;
        synchronized (object) {
            SessionManager.getWaitEventMap().put(socketChannel, selectionKey);
            this.selector.wakeup();
        }
        this.logger.debug("setSelectionKey end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regEvent() {
        this.logger.debug("regEvent begin");
        try {
            Object object = this.regLock;
            synchronized (object) {
                Iterator<Map.Entry<SocketChannel, Integer>> it = SessionManager.getWaitEventMap().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<SocketChannel, Integer> entry = it.next();
                    it.remove();
                    entry.getKey().register(this.selector, entry.getValue());
                    this.logger.debug("reg key:{}", (Object)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("regEvent error!", (Throwable)e);
        }
        this.logger.debug("regEvent end");
    }
}

