/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.isocket;

import cn.ibaijia.isocket.Context;
import cn.ibaijia.isocket.handler.ReadCompletionHandler;
import cn.ibaijia.isocket.handler.WriteCompletionHandler;
import cn.ibaijia.isocket.processor.Processor;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class Client<T>
extends Context
implements Runnable {
    private Map<SocketOption<Object>, Object> options = new HashMap<SocketOption<Object>, Object>();
    private String host;
    private int port;
    private Session<T> session;
    private ExecutorService executorService = null;
    private SocketChannel socketChannel = null;
    private Object connLock = new Object();

    public Client(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Client(String host, int port, Protocol protocol, Processor<T> processor) {
        this.host = host;
        this.port = port;
        this.addProtocol(protocol);
        this.processor = processor;
    }

    public void start() {
        if (this.protocolList.isEmpty() || this.processor == null) {
            this.logger.error("protocol or processor can't be empty");
            return;
        }
        this.startInfo();
        try {
            this.executorService = Executors.newFixedThreadPool(this.threadNumber, new ThreadFactory(){
                byte index = 0;

                @Override
                public Thread newThread(Runnable runnable) {
                    this.index = (byte)(this.index + 1);
                    return new Thread(runnable, "is-nio-c" + this.index);
                }
            });
            this.executorService.execute(this);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.socketChannel = SocketChannel.open();
            if (!this.options.isEmpty()) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.options.entrySet()) {
                    this.socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            this.selector = Selector.open();
            this.socketChannel.connect(new InetSocketAddress(this.host, this.port));
            this.socketChannel.socket().setSoLinger(true, 2);
            this.socketChannel.configureBlocking(false);
            if (this.socketChannel.isConnectionPending()) {
                this.socketChannel.finishConnect();
            }
            this.session = new Session(this.socketChannel, this);
            SessionManager.put(this.session);
            Object object = this.connLock;
            synchronized (object) {
                this.connLock.notifyAll();
            }
            this.process();
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            this.shutdown();
        }
    }

    private void process() {
        try {
            this.socketChannel.register(this.selector, 1);
            block2: while (true) {
                this.regEvent();
                this.selector.select();
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                this.logger.debug("key size:" + readyKeys.size());
                if (this.session == null) {
                    this.logger.error("session is null.");
                    break;
                }
                Iterator<SelectionKey> it = readyKeys.iterator();
                while (true) {
                    if (!it.hasNext()) continue block2;
                    SelectionKey key = it.next();
                    this.logger.debug("key.interestOps():{}", (Object)key.interestOps());
                    it.remove();
                    SocketChannel socketChannel = (SocketChannel)key.channel();
                    socketChannel.configureBlocking(false);
                    if (key.isReadable()) {
                        if (!this.session.isReadLocked()) {
                            this.session.setReadLocked(true);
                            this.executorService.execute(new ReadCompletionHandler<T>(this.session, socketChannel));
                            continue;
                        }
                        this.logger.debug("isReadLocked");
                        continue;
                    }
                    if (key.isWritable()) {
                        if (!this.session.isWriteLocked()) {
                            this.session.setWriteLocked(true);
                            this.executorService.execute(new WriteCompletionHandler<T>(this.session, socketChannel));
                            continue;
                        }
                        this.logger.debug("isWriteLocked");
                        continue;
                    }
                    if (!key.isValid()) continue;
                    this.logger.info("key isValid");
                    this.shutdown();
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("unknown error!", (Throwable)e);
            this.shutdown();
        }
    }

    private void startInfo() {
        this.logger.info("Client StartInfo host:{} port:{} ", (Object)this.host, (Object)this.port);
        this.logger.info("protocol:{} ", (Object)this.protocolList.size());
        this.logger.info("processor:{} ", this.processor.getClass());
        this.logger.info("sessionListener:{} ", this.sessionListener.getClass());
        this.logger.info("readBuffSize:{} ", (Object)this.readBuffSize);
        this.logger.info("useCompactQueue:{},compactBuffSize:{}", (Object)this.useCompactQueue, (Object)this.compactBuffSize);
    }

    public void shutdown() {
        if (this.session != null) {
            SessionManager.close(this.session);
            this.session = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public Client<T> setOption(SocketOption<Object> socketOption, Object value) {
        this.options.put(socketOption, value);
        return this;
    }

    public Client<T> setThreadNumber(Integer threadNumber) {
        this.threadNumber = threadNumber;
        return this;
    }

    public Client<T> setReadBuffSize(int readBuffSize) {
        if (readBuffSize > 4) {
            this.readBuffSize = readBuffSize;
        }
        return this;
    }

    public Client<T> setUseCompactQueue(boolean useCompactQueue) {
        this.useCompactQueue = useCompactQueue;
        return this;
    }

    public Client<T> setCompactBuffSize(int compactBuffSize) {
        this.compactBuffSize = compactBuffSize;
        return this;
    }

    public Client<T> setUseDirectBuffer(boolean useDirectBuffer) {
        this.useDirectBuffer = useDirectBuffer;
        return this;
    }

    public Client<T> setWriteWarnLimit(int writeWarnLimit) {
        this.writeWarnLimit = writeWarnLimit;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session<T> getSession() {
        Object object = this.connLock;
        synchronized (object) {
            if (this.session == null) {
                try {
                    this.connLock.wait(10000L);
                }
                catch (Exception e) {
                    this.logger.error("getSession timeout!", (Throwable)e);
                }
            }
            return this.session;
        }
    }
}

