package cn.ibaijia.isocket.session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static Map<String,Session<?>> sessionMap = new ConcurrentHashMap<String,Session<?>>();
    private static Map<SocketChannel,Integer> waitEventMap = new ConcurrentHashMap<SocketChannel,Integer>();
     
    public static void status(){
    	logger.info("sessionMap size:{},waitEventMap size:{}",sessionMap.size(),waitEventMap.size());
    }

    public static void put(Session<?> session){
        sessionMap.put(session.getSessionID(),session);
    }

    public static Session<?> get(String sessionId){
        return sessionMap.get(sessionId);
    }

    public static Session<?> get(SocketChannel channel){
        String sessionId = genId(channel);
        return sessionMap.get(sessionId);
    }

    public static boolean close(String sessionId){
        Session<?> session = sessionMap.remove(sessionId);
        if(session != null){
            session.close();
            return true;
        }
        return false;
    }

    public static boolean close(SocketChannel channel){
        String sessionId = genId(channel);
        Session<?> session = sessionMap.remove(sessionId);
        if(session != null){
            waitEventMap.remove(session.getChannel());
            session.close();
            return true;
        }
        return false;
    }

    public static boolean close(Session<?> session){
		if (session != null) {
	        logger.info("session closing:{}",session.getSessionID());
            sessionMap.remove(session.getSessionID());
            waitEventMap.remove(session.getChannel());
            session.close();
            return true;
        }
        return false;
    }

    public static String genId(SocketChannel channel){
        String sessionId = null;
        if(channel != null){
            try {
                sessionId = channel.getLocalAddress() + "_"+ channel.getRemoteAddress();
            }catch (Exception e){
                logger.error("genId error.",e);
            }
        }
        return sessionId;
    }

    public static Map<SocketChannel, Integer> getWaitEventMap() {
        return waitEventMap;
    }
}
