package cn.ibaijia.isocket.protocol;

import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FixLengthStringProtocol implements Protocol<ByteBuffer,String> {

    private static final Logger logger = LoggerFactory.getLogger(FixLengthStringProtocol.class);

    private int HEAD_LENGTH = 4;
    private Byte endFlag = '\n';
    private Charset charset = StandardCharsets.UTF_8;

    public FixLengthStringProtocol() {
        if(this.endFlag != null){
            HEAD_LENGTH += 1;
        }
    }

    public FixLengthStringProtocol(Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            HEAD_LENGTH += 1;
        }
    }
    /**
     * cn.ibaijia.soe.core.protocol.lenType
     * @param lenType
     * @param endFlag
     */
    public FixLengthStringProtocol(LenType lenType,Byte endFlag) {
        this.endFlag = endFlag;
        if(this.endFlag != null){
            HEAD_LENGTH += 1;
        }
    }

    @Override
    public String decode(ByteBuffer readBuffer, Session session) {
        logger.debug("decode");
        if (readBuffer.remaining() < HEAD_LENGTH) {
            logger.debug("remaining length:{} < intLen:{}", readBuffer.remaining(), HEAD_LENGTH);
            return null;
        }
        //判断是否存在半包情况
        readBuffer.mark();
        int len = readBuffer.getInt() - HEAD_LENGTH;
        if (readBuffer.remaining() < len) {
            logger.debug("remaining length:{} < msgLen:{}", readBuffer.remaining(), len);
            readBuffer.reset();
            return null;
        }
        byte[] bytes = new byte[len];
        readBuffer.get(bytes);
        if(endFlag != null){
            byte exceptFlag = readBuffer.get();
            if(exceptFlag != endFlag){//预期结束标志不符合
                logger.error("exceptFlag:{} != endFlag:{}, end flag error,make sure you get the string protocol!",exceptFlag,endFlag);
                SessionManager.close(session);
                return null;
            }
        }
        String strData = null;
        try {
            strData = new String(bytes,charset);
        } catch (Exception e) {
            logger.error("bytes to String error,charset:"+charset,e);
            SessionManager.close(session);
        }
        return strData;
    }

    @Override
    public ByteBuffer encode(String object, Session session) {
        logger.debug("encode");
        byte[] bytes = new byte[0];
        try {
            bytes = object.getBytes(charset);
        } catch (Exception e) {
            logger.error("String to bytes error,charset:"+charset,e);
            SessionManager.close(session);
        }
        ByteBuffer buffer = ByteBuffer.allocate(HEAD_LENGTH + bytes.length);
        buffer.putInt(HEAD_LENGTH + bytes.length);
        buffer.put(bytes);
        if(this.endFlag != null){
            buffer.put(endFlag);
        }
        return buffer;
    }

    public Charset getCharset() {
        return charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}
