package cn.ibaijia.isocket.protocol;

import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import cn.ibaijia.isocket.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class FixLengthBigBufferProtocol<B extends Buffer> implements Protocol<ByteBuffer,ByteBuffer> {

    private static final Logger logger = LoggerFactory.getLogger(FixLengthBigBufferProtocol.class);

    private short HEAD_LENGTH = 4;
    private Byte endFlag = '\n';

    private ByteBuffer bigBuffer = null;
    private boolean decodeNew = true;

    public FixLengthBigBufferProtocol() {
        if(this.endFlag != null){
            HEAD_LENGTH += 1;
        }
    }

    public FixLengthBigBufferProtocol(Byte endFlag) {
        this.endFlag = endFlag;
        if (this.endFlag != null) {
            HEAD_LENGTH += 1;
        }
    }

    @Override
    public ByteBuffer decode(ByteBuffer readBuffer, Session session) {
        logger.debug("decode");
        if(readBuffer.remaining() == 0){
            return null;
        }
        //如果新消息
        if(decodeNew){
            decodeNew = false;
            if (readBuffer.remaining() < HEAD_LENGTH) {
                logger.debug("remaining length:{} < HEAD_LENGTH:{}", readBuffer.remaining(), HEAD_LENGTH);
                return null;
            }
            BufferUtil.free(bigBuffer);
            //判断是否存在半包情况
            int len = readBuffer.getInt() - HEAD_LENGTH;
            bigBuffer = BufferUtil.allocate(len,session.getContext().isUseDirectBuffer());
        }

        int readLen = bigBuffer.remaining();//默认读readBuffer可以写完整
        if(readBuffer.remaining() < bigBuffer.remaining()){//如果写不满当前缓冲区
            readLen =readBuffer.remaining();
        }

        byte[] bytes = new byte[readLen];
        readBuffer.get(bytes);
        bigBuffer.put(bytes);

        if(bigBuffer.remaining() == 0){//满了
            if(endFlag != null){
                byte exceptFlag = readBuffer.get();
                if(exceptFlag != endFlag){//预期结束标志不符合
                    logger.error("exceptFlag:{} != endFlag:{}, end flag error,make sure you get the big buffer protocol!",exceptFlag,endFlag);
                    SessionManager.close(session);
                    return null;
                }
            }
            decodeNew = true;
            return bigBuffer;
        }else {
            decodeNew = false;
        }
        return null;
    }

    @Override
    public ByteBuffer encode(ByteBuffer object, Session session) {
        logger.debug("encode");
        if(object == null){
            return null;
        }
        int length = HEAD_LENGTH + object.capacity();
        ByteBuffer buffer = BufferUtil.allocate(length,object.isDirect());
        buffer.putInt(length);
        buffer.put(object);
        if(this.endFlag != null){
            buffer.put(endFlag);
        }
        return buffer;
    }
}
