package cn.ibaijia.isocket.listener;


import cn.ibaijia.isocket.session.Session;

import java.nio.ByteBuffer;

public interface SessionListener {

    /**
     * 建立连接
     *
     * @param session
     */
    void onCreate(Session<?> session);

    /**
     * 读取缓冲区完成
     *
     * @param session
     * @param readSize
     */
    void readComplete(Session<?> session, int readSize);

    /**
     * 读取缓冲区失败
     *
     * @param session
     * @param e
     */
    void readFailed(Session<?> session, ByteBuffer byteBuffer, Throwable e);

    /**
     * 处理前
     *
     * @param session
     * @param msg
     */
    void beforeProcess(Session<?> session, Object msg);

    /**
     * 处理后
     *
     * @param session
     * @param msg
     */
    void afterProcess(Session<?> session, Object msg);

    /**
     * 处理成功
     *
     * @param session
     * @param msg
     */
    void processSuccess(Session<?> session, Object msg);

    /**
     * 处理失败
     *
     * @param session
     * @param msg
     * @param e
     */
    void processFailed(Session<?> session, Object msg, Throwable e);

    /**
     * 写异常
     *
     * @param session
     * @param e
     */
    void writeFailed(Session<?> session, ByteBuffer byteBuffer, Throwable e);

    /**
     * 写完成，可用于垃圾回收
     *
     * @param session
     * @param writeSize
     */
    void writeComplete(Session<?> session, int writeSize);

    /**
     * 写任务预警，可做流控
     *
     * @param session
     * @param cacheSize
     */
    void writeWarn(Session<?> session, int cacheSize);

    /**
     * 关闭中
     *
     * @param session
     */
    void closing(Session<?> session);

    /**
     * 关闭完成（有可能是网络原因）
     *
     * @param session
     */
    void closed(Session<?> session);

}
