package cn.ibaijia.isocket.listener;

import cn.ibaijia.isocket.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.ByteBuffer;

public class DefaultSessionListener implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionListener.class);

    @Override
    public void onCreate(Session session) {
        logger.info("onCreate:{}", session.getSessionID());
    }

    @Override
    public void readComplete(Session session, int readSize) {
        logger.debug("readComplete:{}", session.getSessionID());
    }

    @Override
    public void readFailed(Session session, ByteBuffer byteBuffer, Throwable e) {
        logger.error("readFailed:{}", session.getSessionID(),e);
    }

    @Override
    public void beforeProcess(Session session, Object msg) {
        logger.debug("beforeProcess:{}", session.getSessionID());
    }

    @Override
    public void afterProcess(Session session, Object msg) {
        logger.debug("afterProcess:{}", session.getSessionID());
    }

    @Override
    public void processSuccess(Session session, Object msg) {
        logger.debug("processSuccess:{}", session.getSessionID());
    }

    @Override
    public void processFailed(Session session, Object msg, Throwable e) {
        logger.error("processFailed:{}", session.getSessionID(),e);
    }

    @Override
    public void writeFailed(Session session, ByteBuffer byteBuffer, Throwable e) {
        logger.error("writeFailed:{}", session.getSessionID(),e);
    }

    @Override
    public void writeComplete(Session session, int writeSize) {
        logger.debug("writeComplete:{}", session.getSessionID());
    }

    @Override
    public void writeWarn(Session session, int cacheSize) {
        logger.debug("writeWarn:{},cacheSize:{}", session.getSessionID(), cacheSize);
    }

    @Override
    public void closing(Session session) {
        logger.info("closing:{}" + session.getSessionID());
    }

    @Override
    public void closed(Session session) {
        logger.info("closed:{}", session.getSessionID());
    }
}
