package cn.ibaijia.isocket.handler;

import java.nio.channels.SocketChannel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.ibaijia.isocket.session.Session;

public class ReadCompletionHandler<T> implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReadCompletionHandler.class);

    private Session<T> session;
    private SocketChannel socketChannel;

    public ReadCompletionHandler(Session<T> session,SocketChannel socketChannel) {
        this.session = session;
        this.socketChannel = socketChannel;
    }

    @Override
    public void run() {
        session.processReadBuffer();
        session.setReadLocked(false);
        session.readNext();
    }
}