package cn.ibaijia.isocket.handler;

import cn.ibaijia.isocket.Context;
import cn.ibaijia.isocket.session.Session;
import cn.ibaijia.isocket.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class AcceptCompletionHandler<T> implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AcceptCompletionHandler.class);

    private Context<T> context;
    private SocketChannel socketChannel;

    public AcceptCompletionHandler(Context<T> context, SocketChannel socketChannel) {
        this.context = context;
        this.socketChannel = socketChannel;
    }

    @Override
    public void run() {
        createSession(socketChannel);
    }

    private void createSession(SocketChannel channel) {
        String remote = getRemoteAddress(channel);
        logger.info("nio server createSession:{}", remote);
        if (remote == null) {
            logger.error("can't get remote address, abort.");
            return;
        }
        Session<T> session = new Session(channel, context);
        SessionManager.put(session);
        context.setSelectionKey(socketChannel, SelectionKey.OP_READ);
    }

    private String getRemoteAddress(SocketChannel channel) {
        try {
            return channel.getRemoteAddress().toString();
        } catch (Exception e) {
            logger.error("getRemoteAddress error!", e);
            return null;
        }
    }

}
