package cn.ibaijia.isocket;

import cn.ibaijia.isocket.listener.DefaultSessionListener;
import cn.ibaijia.isocket.listener.SessionListener;
import cn.ibaijia.isocket.processor.Processor;
import cn.ibaijia.isocket.protocol.Protocol;
import cn.ibaijia.isocket.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.*;

public abstract class Context<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 协议编码解码器
     */
    protected List<Protocol> protocolList = new ArrayList<Protocol>();
    /**
     * 业务数据处理器
     */
    protected Processor<T> processor;
    /**
     * Session监听器
     */
    protected SessionListener sessionListener = new DefaultSessionListener();
    /**
     * 线程池数
     */
    protected int threadNumber = 2;
    /**
     * 读缓冲区大小
     */
    protected int readBuffSize = 256 * 1024;
    /**
     * 是否使用压缩缓冲区
     */
    protected boolean useCompactQueue = false;
    /**
     * 压缩缓冲区大小
     */
    protected int compactBuffSize = 100 * 1024;
    /**
     * 只对读缓冲区 和 big buffer缓冲区有效
     */
    protected boolean useDirectBuffer = false;
    /**
     * 写缓冲区预警数
     */
    protected int writeWarnLimit = 500;

    protected Set<String> blackList;

    protected Selector selector = null;
    protected int selectionKey = SelectionKey.OP_READ;
    protected Object regLock = new Object();

    public List<Protocol> getProtocolList() {
        return protocolList;
    }

    public Context addProtocol(Protocol protocol) {
        this.protocolList.add(protocol);
        return this;
    }
    
    public void setProcessor(Processor<T> processor) {
        this.processor = processor;
    }

    public Processor<T> getProcessor() {
        return processor;
    }

    public SessionListener getSessionListener() {
        return sessionListener;
    }

    public Context<?> setSessionListener(SessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public int getThreadNumber() {
        return threadNumber;
    }

    public int getReadBuffSize() {
        return readBuffSize;
    }

    public boolean isUseCompactQueue() {
        return useCompactQueue;
    }

    public int getCompactBuffSize() {
        return compactBuffSize;
    }

    public boolean isUseDirectBuffer() {
        return useDirectBuffer;
    }

    public int getWriteWarnLimit() {
        return writeWarnLimit;
    }

    public Set<String> getBlackList() {
        return blackList;
    }

    public void setBlackList(Set<String> blackList) {
        this.blackList = blackList;
    }

    public Selector getSelector() {
        return selector;
    }

    public void setSelectionKey(SocketChannel socketChannel, Integer selectionKey) {
        logger.debug("setSelectionKey begin");
        synchronized (regLock) {
            SessionManager.getWaitEventMap().put(socketChannel, selectionKey);
            selector.wakeup();
        }
        logger.debug("setSelectionKey end");
    }

    protected void regEvent() {
        logger.debug("regEvent begin");
        try {
            synchronized (regLock) {
                Iterator<Map.Entry<SocketChannel, Integer>> it = SessionManager.getWaitEventMap().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<SocketChannel, Integer> entry = it.next();
                    it.remove();
                    entry.getKey().register(selector, entry.getValue());
                    logger.debug("reg key:{}", entry.getValue());
                }
            }
        } catch (Exception e) {
            logger.error("regEvent error!", e);
        }
        logger.debug("regEvent end");
    }
}
