/*
 * Decompiled with CFR 0.152.
 */
package cn.hydrz.dipper.api;

import cn.hydrz.dipper.api.ApiException;
import cn.hydrz.dipper.api.IResultCode;
import cn.hydrz.dipper.api.ResultCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ApiModel(description="\u8fd4\u56de\u4fe1\u606f")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u627f\u8f7d\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u72b6\u6001\u7801", required=true)
    private int code;
    @ApiModelProperty(value="\u8fd4\u56de\u6d88\u606f", required=true)
    private String msg;

    public static boolean isSuccess(R<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)ResultCode.SUCCESS.code, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(R<?> result) {
        return !R.isSuccess(result);
    }

    public static <T> R<T> ok() {
        return R.ok(ResultCode.SUCCESS);
    }

    public static <T> R<T> ok(String msg) {
        return R.ok(null, msg);
    }

    public static <T> R<T> ok(T data) {
        return R.ok(data, ResultCode.SUCCESS);
    }

    public static <T> R<T> ok(IResultCode resultCode) {
        return R.ok(null, resultCode);
    }

    public static <T> R<T> ok(T data, String msg) {
        return R.ok(data, ResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> R<T> ok(T data, int code, String msg) {
        R<T> result = R.ok(data, ResultCode.SUCCESS);
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> R<T> ok(T data, IResultCode resultCode) {
        R<T> result = new R<T>(data, resultCode.getCode(), resultCode.getMessage());
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        response.setStatus(resultCode.getHttpStatus());
        return result;
    }

    public static <T> R<T> failed() {
        return R.failed(ResultCode.FAILURE);
    }

    public static <T> R<T> failed(String msg) {
        return R.failed(msg, null);
    }

    public static <T> R<T> failed(T data) {
        return R.failed(ResultCode.FAILURE, data);
    }

    public static <T> R<T> failed(IResultCode resultCode) {
        return R.failed(ResultCode.FAILURE, null);
    }

    public static <T> R<T> failed(String msg, T data) {
        return R.failed(ResultCode.FAILURE.getCode(), msg, data);
    }

    public static <T> R<T> failed(int code, String msg, T data) {
        R<T> tr = new R<T>(data, code, msg);
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        response.setStatus(ResultCode.FAILURE.httpStatus);
        throw new ApiException(tr);
    }

    public static <T> R<T> failed(IResultCode resultCode, T data) {
        R<T> tr = new R<T>(data, resultCode.getCode(), resultCode.getMessage());
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        response.setStatus(resultCode.getHttpStatus());
        throw new ApiException(tr);
    }

    public T getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return "R(data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    public R() {
    }

    public R(T data, int code, String msg) {
        this.data = data;
        this.code = code;
        this.msg = msg;
    }
}

