/*
 *      Copyright (c) 2018-2028, Chill Zhuang All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  Neither the name of the dreamlu.net developer nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  Author: Chill 庄骞 (smallchill@163.com)
 */
package cn.hydrz.dipper.api;

import java.io.Serializable;

/**
 * 业务代码接口
 *
 * @author hydrz
 */
public interface IResultCode extends Serializable {
    /**
     * 获取Http状态码
     *
     * @return 获取Http状态码
     */
    int getHttpStatus();

    /**
     * 获取状态码
     *
     * @return 获取状态码
     */
    int getCode();

    /**
     * 获取消息
     *
     * @return 获取消息
     */
    String getMessage();
}
