/*
 * Decompiled with CFR 0.152.
 */
package com.lalamove.huolala.dynamicbase.util;

import com.lalamove.huolala.dynamicbase.util.CloseUtil;
import com.lalamove.huolala.dynamicbase.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Util {
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Md5Util() {
    }

    public static String getFileMD5(String filePath, boolean isUpperCase) {
        if (Md5Util.isSpaceString(filePath)) {
            return "";
        }
        return Md5Util.getFileMD5(new File(filePath), isUpperCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileMD5(File file, boolean isUpperCase) {
        String string;
        if (file == null) {
            return "";
        }
        DigestInputStream dis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            string = Md5Util.bytes2HexString(md.digest(), isUpperCase);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close(dis);
                CloseUtil.close(fis);
                throw throwable;
            }
            CloseUtil.close(dis);
            CloseUtil.close(fis);
            return "";
        }
        CloseUtil.close(dis);
        CloseUtil.close(fis);
        return string;
    }

    private static String bytes2HexString(byte[] bytes, boolean isUpperCase) {
        if (bytes == null) {
            return "";
        }
        char[] hexDigits = isUpperCase ? HEX_DIGITS_UPPER : HEX_DIGITS_LOWER;
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    private static boolean isSpaceString(String filePath) {
        if (TextUtil.isEmpty(filePath)) {
            return true;
        }
        int len = filePath.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(filePath.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

