/*
 * Decompiled with CFR 0.152.
 */
package com.lalamove.huolala.dynamicbase.util;

import com.lalamove.huolala.dynamicbase.util.CloseUtil;
import com.lalamove.huolala.dynamicbase.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String oldPathFile, String newPathFile) {
        FileInputStream inStream;
        FileOutputStream fs;
        block7: {
            boolean bl;
            if (TextUtil.equals(oldPathFile, newPathFile)) {
                return false;
            }
            fs = null;
            inStream = null;
            try {
                int byteRead = 0;
                File oldFile = new File(oldPathFile);
                if (!oldFile.exists()) break block7;
                inStream = new FileInputStream(oldPathFile);
                File n = new File(newPathFile);
                if (!n.exists()) {
                    n.createNewFile();
                }
                fs = new FileOutputStream(newPathFile);
                byte[] buffer = new byte[1024];
                while ((byteRead = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteRead);
                }
                fs.flush();
                bl = true;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CloseUtil.close(fs);
                    CloseUtil.close(inStream);
                    throw throwable;
                }
                CloseUtil.close(fs);
                CloseUtil.close(inStream);
            }
            CloseUtil.close(fs);
            CloseUtil.close(inStream);
            return bl;
        }
        CloseUtil.close(fs);
        CloseUtil.close(inStream);
        return false;
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static RenameResult forceRename(File file, String newName) {
        boolean res;
        if (file == null || !file.exists()) {
            return new RenameResult(false, null);
        }
        if (TextUtil.isEmpty(newName) || FileUtil.isSpaceString(newName)) {
            return new RenameResult(false, null);
        }
        if (newName.equals(file.getName())) {
            return new RenameResult(true, null);
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        if (newFile.exists()) {
            newFile.delete();
        }
        newFile = (res = file.renameTo(newFile)) ? newFile : null;
        return new RenameResult(res, newFile);
    }

    public static boolean isSpaceString(String filePath) {
        if (TextUtil.isEmpty(filePath)) {
            return true;
        }
        int len = filePath.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(filePath.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteFileOrDir(String path, boolean deleteSelf) {
        if (TextUtil.isEmpty(path)) {
            return false;
        }
        return FileUtil.deleteFileOrDir(new File(path), deleteSelf);
    }

    public static boolean deleteFileOrDir(File rootFile, boolean deleteSelf) {
        if (rootFile == null) {
            return false;
        }
        if (!rootFile.exists()) {
            return true;
        }
        if (rootFile.isFile()) {
            return rootFile.delete();
        }
        if (!rootFile.isDirectory()) {
            return false;
        }
        File[] files = rootFile.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtil.deleteFileOrDir(file, true))) continue;
            return false;
        }
        if (deleteSelf) {
            return rootFile.delete();
        }
        return true;
    }

    public static class RenameResult {
        public final boolean res;
        public final File file;

        public RenameResult(boolean res, File file) {
            this.res = res;
            this.file = file;
        }
    }
}

