/*
 * Decompiled with CFR 0.152.
 */
package com.lalamove.huolala.dynamicbase.so;

import com.lalamove.huolala.dynamicbase.so.ILoadSoListener;
import com.lalamove.huolala.dynamicbase.so.ILoadSoManager;
import com.lalamove.huolala.dynamicbase.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class StaticLoadSoManager
implements ILoadSoManager {
    private boolean mLoadSucceed = false;

    @Override
    public boolean isSoReady(String libName) {
        return this.mLoadSucceed;
    }

    @Override
    public void loadSo(String libName, ILoadSoListener listener) {
        try {
            List<String> list = this.getLibList(libName);
            if (list == null || list.isEmpty()) {
                this.dispatchError(listener, new IllegalArgumentException(" can not find libName "));
                return;
            }
            for (String str : list) {
                System.loadLibrary(str);
            }
            this.dispatchSucceed(listener, "");
            this.mLoadSucceed = true;
        }
        catch (Exception e) {
            this.dispatchError(listener, e);
        }
    }

    private void dispatchError(ILoadSoListener listener, Throwable t) {
        if (listener != null) {
            listener.onError(t);
        }
    }

    private void dispatchSucceed(ILoadSoListener listener, String path) {
        if (listener != null) {
            listener.onSucceed(path);
        }
    }

    protected List<String> getLibList(String libName) {
        ArrayList<String> list = new ArrayList<String>();
        if (!TextUtil.isEmpty(libName)) {
            list.add(libName);
        }
        return list;
    }
}

