/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.support;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

public class ScriptRunner {
    private static final Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    private boolean continueOnError;
    private String separator;

    public void runScript(DataSource dataSource, String location) {
        if (StringUtils.hasText((String)location)) {
            ClassPathResource resource;
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            populator.setContinueOnError(this.continueOnError);
            populator.setSeparator(this.separator);
            if (location.startsWith("classpath:")) {
                location = location.substring(10);
            }
            if ((resource = new ClassPathResource(location)).exists()) {
                populator.addScript((Resource)resource);
                try {
                    DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
                }
                catch (Exception e) {
                    log.warn("execute sql error", (Throwable)e);
                }
            } else {
                log.warn("could not find schema or data file {}", (Object)location);
            }
        }
    }

    public ScriptRunner(boolean continueOnError, String separator) {
        this.continueOnError = continueOnError;
        this.separator = separator;
    }
}

