/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.support;

import cn.humingfeng.dynamic.datasource.DynamicRoutingDataSource;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class DbHealthIndicator
extends AbstractHealthIndicator {
    private static Map<String, Boolean> DB_HEALTH = new ConcurrentHashMap<String, Boolean>();
    private DataSource dataSource;

    public DbHealthIndicator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static boolean getDbHealth(String dataSource) {
        return DB_HEALTH.get(dataSource);
    }

    public static Boolean setDbHealth(String dataSource, boolean health) {
        return DB_HEALTH.put(dataSource, health);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.dataSource instanceof DynamicRoutingDataSource) {
            Map<String, DataSource> dataSourceMap = ((DynamicRoutingDataSource)((Object)this.dataSource)).getCurrentDataSources();
            for (Map.Entry<String, DataSource> dataSource : dataSourceMap.entrySet()) {
                Integer result = 0;
                try {
                    result = this.query(dataSource.getValue());
                    DB_HEALTH.put(dataSource.getKey(), 1 == result);
                }
                catch (Throwable throwable) {
                    DB_HEALTH.put(dataSource.getKey(), 1 == result);
                    builder.withDetail(dataSource.getKey(), (Object)result);
                    throw throwable;
                }
                builder.withDetail(dataSource.getKey(), (Object)result);
            }
        }
    }

    private Integer query(DataSource dataSource) {
        List results = new JdbcTemplate(dataSource).query("SELECT 1", (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet resultSet, int i) throws SQLException {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columns = metaData.getColumnCount();
                if (columns != 1) {
                    throw new IncorrectResultSetColumnCountException(1, columns);
                }
                return (Integer)JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)1, Integer.class);
            }
        });
        return (Integer)DataAccessUtils.requiredSingleResult((Collection)results);
    }
}

