/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.hikari;

import com.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCpConfig {
    private static final Logger log = LoggerFactory.getLogger(HikariCpConfig.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final int DEFAULT_POOL_SIZE = 10;
    private String username;
    private String password;
    private String driverClassName;
    private String jdbcUrl;
    private String poolName;
    private String catalog;
    private Long connectionTimeout;
    private Long validationTimeout;
    private Long idleTimeout;
    private Long leakDetectionThreshold;
    private Long maxLifetime;
    private Integer maxPoolSize;
    private Integer minIdle;
    private Long initializationFailTimeout;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String schema;
    private String transactionIsolationName;
    private Boolean isAutoCommit;
    private Boolean isReadOnly;
    private Boolean isIsolateInternalQueries;
    private Boolean isRegisterMbeans;
    private Boolean isAllowPoolSuspension;
    private Properties dataSourceProperties;
    private Properties healthCheckProperties;

    public HikariConfig toHikariConfig(HikariCpConfig g) {
        Properties tempHealthCheckProperties;
        Properties tempDataSourceProperties;
        Boolean tempAllowPoolSuspension;
        Boolean tempRegisterMbeans;
        Boolean tempIsolateInternalQueries;
        Boolean tempReadOnly;
        Boolean tempAutoCommit;
        String tempTransactionIsolationName;
        String tempDataSourceJndiName;
        String tempDataSourceClassName;
        String tempConnectionTestQuery;
        String tempConnectionInitSql;
        Long tempInitializationFailTimeout;
        Integer tempMinIdle;
        Integer tempMaxPoolSize;
        Long tempMaxLifetime;
        Long tempLeakDetectionThreshold;
        Long tempIdleTimeout;
        Long tempValidationTimeout;
        Long tempConnectionTimeout;
        String tempCatalog;
        String tempSchema;
        HikariConfig config = new HikariConfig();
        String string = tempSchema = this.schema == null ? g.getSchema() : this.schema;
        if (tempSchema != null) {
            try {
                Field schemaField = HikariConfig.class.getDeclaredField("schema");
                schemaField.setAccessible(true);
                schemaField.set(config, tempSchema);
            }
            catch (NoSuchFieldException e) {
                log.warn("\u52a8\u6001\u6570\u636e\u6e90-\u8bbe\u7f6e\u4e86Hikari\u7684schema\u5c5e\u6027\uff0c\u4f46\u5f53\u524dHikari\u7248\u672c\u4e0d\u652f\u6301");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        String string2 = tempCatalog = this.catalog == null ? g.getCatalog() : this.catalog;
        if (tempCatalog != null) {
            config.setCatalog(tempCatalog);
        }
        Long l = tempConnectionTimeout = this.connectionTimeout == null ? g.getConnectionTimeout() : this.connectionTimeout;
        if (tempConnectionTimeout != null && !tempConnectionTimeout.equals(CONNECTION_TIMEOUT)) {
            config.setConnectionTimeout(tempConnectionTimeout.longValue());
        }
        Long l2 = tempValidationTimeout = this.validationTimeout == null ? g.getValidationTimeout() : this.validationTimeout;
        if (tempValidationTimeout != null && !tempValidationTimeout.equals(VALIDATION_TIMEOUT)) {
            config.setValidationTimeout(tempValidationTimeout.longValue());
        }
        Long l3 = tempIdleTimeout = this.idleTimeout == null ? g.getIdleTimeout() : this.idleTimeout;
        if (tempIdleTimeout != null && !tempIdleTimeout.equals(IDLE_TIMEOUT)) {
            config.setIdleTimeout(tempIdleTimeout.longValue());
        }
        Long l4 = tempLeakDetectionThreshold = this.leakDetectionThreshold == null ? g.getLeakDetectionThreshold() : this.leakDetectionThreshold;
        if (tempLeakDetectionThreshold != null) {
            config.setLeakDetectionThreshold(tempLeakDetectionThreshold.longValue());
        }
        Long l5 = tempMaxLifetime = this.maxLifetime == null ? g.getMaxLifetime() : this.maxLifetime;
        if (tempMaxLifetime != null && !tempMaxLifetime.equals(MAX_LIFETIME)) {
            config.setMaxLifetime(tempMaxLifetime.longValue());
        }
        Integer n = tempMaxPoolSize = this.maxPoolSize == null ? g.getMaxPoolSize() : this.maxPoolSize;
        if (tempMaxPoolSize != null && !tempMaxPoolSize.equals(-1)) {
            config.setMaximumPoolSize(tempMaxPoolSize.intValue());
        }
        Integer n2 = tempMinIdle = this.minIdle == null ? g.getMinIdle() : this.getMinIdle();
        if (tempMinIdle != null && !tempMinIdle.equals(-1)) {
            config.setMinimumIdle(tempMinIdle.intValue());
        }
        Long l6 = tempInitializationFailTimeout = this.initializationFailTimeout == null ? g.getInitializationFailTimeout() : this.initializationFailTimeout;
        if (tempInitializationFailTimeout != null && !tempInitializationFailTimeout.equals(1L)) {
            config.setInitializationFailTimeout(tempInitializationFailTimeout.longValue());
        }
        String string3 = tempConnectionInitSql = this.connectionInitSql == null ? g.getConnectionInitSql() : this.connectionInitSql;
        if (tempConnectionInitSql != null) {
            config.setConnectionInitSql(tempConnectionInitSql);
        }
        String string4 = tempConnectionTestQuery = this.connectionTestQuery == null ? g.getConnectionTestQuery() : this.connectionTestQuery;
        if (tempConnectionTestQuery != null) {
            config.setConnectionTestQuery(tempConnectionTestQuery);
        }
        String string5 = tempDataSourceClassName = this.dataSourceClassName == null ? g.getDataSourceClassName() : this.dataSourceClassName;
        if (tempDataSourceClassName != null) {
            config.setDataSourceClassName(tempDataSourceClassName);
        }
        String string6 = tempDataSourceJndiName = this.dataSourceJndiName == null ? g.getDataSourceJndiName() : this.dataSourceJndiName;
        if (tempDataSourceJndiName != null) {
            config.setDataSourceJNDI(tempDataSourceJndiName);
        }
        String string7 = tempTransactionIsolationName = this.transactionIsolationName == null ? g.getTransactionIsolationName() : this.transactionIsolationName;
        if (tempTransactionIsolationName != null) {
            config.setTransactionIsolation(tempTransactionIsolationName);
        }
        Boolean bl = tempAutoCommit = this.isAutoCommit == null ? g.getIsAutoCommit() : this.isAutoCommit;
        if (tempAutoCommit != null && tempAutoCommit.equals(Boolean.FALSE)) {
            config.setAutoCommit(false);
        }
        Boolean bl2 = tempReadOnly = this.isReadOnly == null ? g.getIsReadOnly() : this.isReadOnly;
        if (tempReadOnly != null) {
            config.setReadOnly(tempReadOnly.booleanValue());
        }
        Boolean bl3 = tempIsolateInternalQueries = this.isIsolateInternalQueries == null ? g.getIsIsolateInternalQueries() : this.isIsolateInternalQueries;
        if (tempIsolateInternalQueries != null) {
            config.setIsolateInternalQueries(tempIsolateInternalQueries.booleanValue());
        }
        Boolean bl4 = tempRegisterMbeans = this.isRegisterMbeans == null ? g.getIsRegisterMbeans() : this.isRegisterMbeans;
        if (tempRegisterMbeans != null) {
            config.setRegisterMbeans(tempRegisterMbeans.booleanValue());
        }
        Boolean bl5 = tempAllowPoolSuspension = this.isAllowPoolSuspension == null ? g.getIsAllowPoolSuspension() : this.isAllowPoolSuspension;
        if (tempAllowPoolSuspension != null) {
            config.setAllowPoolSuspension(tempAllowPoolSuspension.booleanValue());
        }
        Properties properties = tempDataSourceProperties = this.dataSourceProperties == null ? g.getDataSourceProperties() : this.dataSourceProperties;
        if (tempDataSourceProperties != null) {
            config.setDataSourceProperties(tempDataSourceProperties);
        }
        Properties properties2 = tempHealthCheckProperties = this.healthCheckProperties == null ? g.getHealthCheckProperties() : this.healthCheckProperties;
        if (tempHealthCheckProperties != null) {
            config.setHealthCheckProperties(tempHealthCheckProperties);
        }
        return config;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getValidationTimeout() {
        return this.validationTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public Long getMaxLifetime() {
        return this.maxLifetime;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Long getInitializationFailTimeout() {
        return this.initializationFailTimeout;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTransactionIsolationName() {
        return this.transactionIsolationName;
    }

    public Boolean getIsAutoCommit() {
        return this.isAutoCommit;
    }

    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public Boolean getIsIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public Boolean getIsRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public Boolean getIsAllowPoolSuspension() {
        return this.isAllowPoolSuspension;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public Properties getHealthCheckProperties() {
        return this.healthCheckProperties;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setValidationTimeout(Long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setLeakDetectionThreshold(Long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    public void setMaxLifetime(Long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setInitializationFailTimeout(Long initializationFailTimeout) {
        this.initializationFailTimeout = initializationFailTimeout;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTransactionIsolationName(String transactionIsolationName) {
        this.transactionIsolationName = transactionIsolationName;
    }

    public void setIsAutoCommit(Boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setIsIsolateInternalQueries(Boolean isIsolateInternalQueries) {
        this.isIsolateInternalQueries = isIsolateInternalQueries;
    }

    public void setIsRegisterMbeans(Boolean isRegisterMbeans) {
        this.isRegisterMbeans = isRegisterMbeans;
    }

    public void setIsAllowPoolSuspension(Boolean isAllowPoolSuspension) {
        this.isAllowPoolSuspension = isAllowPoolSuspension;
    }

    public void setDataSourceProperties(Properties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public void setHealthCheckProperties(Properties healthCheckProperties) {
        this.healthCheckProperties = healthCheckProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariCpConfig)) {
            return false;
        }
        HikariCpConfig other = (HikariCpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        Long this$connectionTimeout = this.getConnectionTimeout();
        Long other$connectionTimeout = other.getConnectionTimeout();
        if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
            return false;
        }
        Long this$validationTimeout = this.getValidationTimeout();
        Long other$validationTimeout = other.getValidationTimeout();
        if (this$validationTimeout == null ? other$validationTimeout != null : !((Object)this$validationTimeout).equals(other$validationTimeout)) {
            return false;
        }
        Long this$idleTimeout = this.getIdleTimeout();
        Long other$idleTimeout = other.getIdleTimeout();
        if (this$idleTimeout == null ? other$idleTimeout != null : !((Object)this$idleTimeout).equals(other$idleTimeout)) {
            return false;
        }
        Long this$leakDetectionThreshold = this.getLeakDetectionThreshold();
        Long other$leakDetectionThreshold = other.getLeakDetectionThreshold();
        if (this$leakDetectionThreshold == null ? other$leakDetectionThreshold != null : !((Object)this$leakDetectionThreshold).equals(other$leakDetectionThreshold)) {
            return false;
        }
        Long this$maxLifetime = this.getMaxLifetime();
        Long other$maxLifetime = other.getMaxLifetime();
        if (this$maxLifetime == null ? other$maxLifetime != null : !((Object)this$maxLifetime).equals(other$maxLifetime)) {
            return false;
        }
        Integer this$maxPoolSize = this.getMaxPoolSize();
        Integer other$maxPoolSize = other.getMaxPoolSize();
        if (this$maxPoolSize == null ? other$maxPoolSize != null : !((Object)this$maxPoolSize).equals(other$maxPoolSize)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Long this$initializationFailTimeout = this.getInitializationFailTimeout();
        Long other$initializationFailTimeout = other.getInitializationFailTimeout();
        if (this$initializationFailTimeout == null ? other$initializationFailTimeout != null : !((Object)this$initializationFailTimeout).equals(other$initializationFailTimeout)) {
            return false;
        }
        String this$connectionInitSql = this.getConnectionInitSql();
        String other$connectionInitSql = other.getConnectionInitSql();
        if (this$connectionInitSql == null ? other$connectionInitSql != null : !this$connectionInitSql.equals(other$connectionInitSql)) {
            return false;
        }
        String this$connectionTestQuery = this.getConnectionTestQuery();
        String other$connectionTestQuery = other.getConnectionTestQuery();
        if (this$connectionTestQuery == null ? other$connectionTestQuery != null : !this$connectionTestQuery.equals(other$connectionTestQuery)) {
            return false;
        }
        String this$dataSourceClassName = this.getDataSourceClassName();
        String other$dataSourceClassName = other.getDataSourceClassName();
        if (this$dataSourceClassName == null ? other$dataSourceClassName != null : !this$dataSourceClassName.equals(other$dataSourceClassName)) {
            return false;
        }
        String this$dataSourceJndiName = this.getDataSourceJndiName();
        String other$dataSourceJndiName = other.getDataSourceJndiName();
        if (this$dataSourceJndiName == null ? other$dataSourceJndiName != null : !this$dataSourceJndiName.equals(other$dataSourceJndiName)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$transactionIsolationName = this.getTransactionIsolationName();
        String other$transactionIsolationName = other.getTransactionIsolationName();
        if (this$transactionIsolationName == null ? other$transactionIsolationName != null : !this$transactionIsolationName.equals(other$transactionIsolationName)) {
            return false;
        }
        Boolean this$isAutoCommit = this.getIsAutoCommit();
        Boolean other$isAutoCommit = other.getIsAutoCommit();
        if (this$isAutoCommit == null ? other$isAutoCommit != null : !((Object)this$isAutoCommit).equals(other$isAutoCommit)) {
            return false;
        }
        Boolean this$isReadOnly = this.getIsReadOnly();
        Boolean other$isReadOnly = other.getIsReadOnly();
        if (this$isReadOnly == null ? other$isReadOnly != null : !((Object)this$isReadOnly).equals(other$isReadOnly)) {
            return false;
        }
        Boolean this$isIsolateInternalQueries = this.getIsIsolateInternalQueries();
        Boolean other$isIsolateInternalQueries = other.getIsIsolateInternalQueries();
        if (this$isIsolateInternalQueries == null ? other$isIsolateInternalQueries != null : !((Object)this$isIsolateInternalQueries).equals(other$isIsolateInternalQueries)) {
            return false;
        }
        Boolean this$isRegisterMbeans = this.getIsRegisterMbeans();
        Boolean other$isRegisterMbeans = other.getIsRegisterMbeans();
        if (this$isRegisterMbeans == null ? other$isRegisterMbeans != null : !((Object)this$isRegisterMbeans).equals(other$isRegisterMbeans)) {
            return false;
        }
        Boolean this$isAllowPoolSuspension = this.getIsAllowPoolSuspension();
        Boolean other$isAllowPoolSuspension = other.getIsAllowPoolSuspension();
        if (this$isAllowPoolSuspension == null ? other$isAllowPoolSuspension != null : !((Object)this$isAllowPoolSuspension).equals(other$isAllowPoolSuspension)) {
            return false;
        }
        Properties this$dataSourceProperties = this.getDataSourceProperties();
        Properties other$dataSourceProperties = other.getDataSourceProperties();
        if (this$dataSourceProperties == null ? other$dataSourceProperties != null : !((Object)this$dataSourceProperties).equals(other$dataSourceProperties)) {
            return false;
        }
        Properties this$healthCheckProperties = this.getHealthCheckProperties();
        Properties other$healthCheckProperties = other.getHealthCheckProperties();
        return !(this$healthCheckProperties == null ? other$healthCheckProperties != null : !((Object)this$healthCheckProperties).equals(other$healthCheckProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariCpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        Long $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        Long $validationTimeout = this.getValidationTimeout();
        result = result * 59 + ($validationTimeout == null ? 43 : ((Object)$validationTimeout).hashCode());
        Long $idleTimeout = this.getIdleTimeout();
        result = result * 59 + ($idleTimeout == null ? 43 : ((Object)$idleTimeout).hashCode());
        Long $leakDetectionThreshold = this.getLeakDetectionThreshold();
        result = result * 59 + ($leakDetectionThreshold == null ? 43 : ((Object)$leakDetectionThreshold).hashCode());
        Long $maxLifetime = this.getMaxLifetime();
        result = result * 59 + ($maxLifetime == null ? 43 : ((Object)$maxLifetime).hashCode());
        Integer $maxPoolSize = this.getMaxPoolSize();
        result = result * 59 + ($maxPoolSize == null ? 43 : ((Object)$maxPoolSize).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Long $initializationFailTimeout = this.getInitializationFailTimeout();
        result = result * 59 + ($initializationFailTimeout == null ? 43 : ((Object)$initializationFailTimeout).hashCode());
        String $connectionInitSql = this.getConnectionInitSql();
        result = result * 59 + ($connectionInitSql == null ? 43 : $connectionInitSql.hashCode());
        String $connectionTestQuery = this.getConnectionTestQuery();
        result = result * 59 + ($connectionTestQuery == null ? 43 : $connectionTestQuery.hashCode());
        String $dataSourceClassName = this.getDataSourceClassName();
        result = result * 59 + ($dataSourceClassName == null ? 43 : $dataSourceClassName.hashCode());
        String $dataSourceJndiName = this.getDataSourceJndiName();
        result = result * 59 + ($dataSourceJndiName == null ? 43 : $dataSourceJndiName.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $transactionIsolationName = this.getTransactionIsolationName();
        result = result * 59 + ($transactionIsolationName == null ? 43 : $transactionIsolationName.hashCode());
        Boolean $isAutoCommit = this.getIsAutoCommit();
        result = result * 59 + ($isAutoCommit == null ? 43 : ((Object)$isAutoCommit).hashCode());
        Boolean $isReadOnly = this.getIsReadOnly();
        result = result * 59 + ($isReadOnly == null ? 43 : ((Object)$isReadOnly).hashCode());
        Boolean $isIsolateInternalQueries = this.getIsIsolateInternalQueries();
        result = result * 59 + ($isIsolateInternalQueries == null ? 43 : ((Object)$isIsolateInternalQueries).hashCode());
        Boolean $isRegisterMbeans = this.getIsRegisterMbeans();
        result = result * 59 + ($isRegisterMbeans == null ? 43 : ((Object)$isRegisterMbeans).hashCode());
        Boolean $isAllowPoolSuspension = this.getIsAllowPoolSuspension();
        result = result * 59 + ($isAllowPoolSuspension == null ? 43 : ((Object)$isAllowPoolSuspension).hashCode());
        Properties $dataSourceProperties = this.getDataSourceProperties();
        result = result * 59 + ($dataSourceProperties == null ? 43 : ((Object)$dataSourceProperties).hashCode());
        Properties $healthCheckProperties = this.getHealthCheckProperties();
        result = result * 59 + ($healthCheckProperties == null ? 43 : ((Object)$healthCheckProperties).hashCode());
        return result;
    }

    public String toString() {
        return "HikariCpConfig(username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", jdbcUrl=" + this.getJdbcUrl() + ", poolName=" + this.getPoolName() + ", catalog=" + this.getCatalog() + ", connectionTimeout=" + this.getConnectionTimeout() + ", validationTimeout=" + this.getValidationTimeout() + ", idleTimeout=" + this.getIdleTimeout() + ", leakDetectionThreshold=" + this.getLeakDetectionThreshold() + ", maxLifetime=" + this.getMaxLifetime() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minIdle=" + this.getMinIdle() + ", initializationFailTimeout=" + this.getInitializationFailTimeout() + ", connectionInitSql=" + this.getConnectionInitSql() + ", connectionTestQuery=" + this.getConnectionTestQuery() + ", dataSourceClassName=" + this.getDataSourceClassName() + ", dataSourceJndiName=" + this.getDataSourceJndiName() + ", schema=" + this.getSchema() + ", transactionIsolationName=" + this.getTransactionIsolationName() + ", isAutoCommit=" + this.getIsAutoCommit() + ", isReadOnly=" + this.getIsReadOnly() + ", isIsolateInternalQueries=" + this.getIsIsolateInternalQueries() + ", isRegisterMbeans=" + this.getIsRegisterMbeans() + ", isAllowPoolSuspension=" + this.getIsAllowPoolSuspension() + ", dataSourceProperties=" + this.getDataSourceProperties() + ", healthCheckProperties=" + this.getHealthCheckProperties() + ")";
    }
}

