/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure;

import cn.humingfeng.dynamic.datasource.creator.BasicDataSourceCreator;
import cn.humingfeng.dynamic.datasource.creator.DataSourceCreator;
import cn.humingfeng.dynamic.datasource.creator.DruidDataSourceCreator;
import cn.humingfeng.dynamic.datasource.creator.GbaseDataSourceCreator;
import cn.humingfeng.dynamic.datasource.creator.HikariDataSourceCreator;
import cn.humingfeng.dynamic.datasource.creator.JndiDataSourceCreator;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
public class DynamicDataSourceCreatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceCreatorAutoConfiguration.class);
    private final DynamicDataSourceProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public DataSourceCreator dataSourceCreator() {
        DataSourceCreator dataSourceCreator = new DataSourceCreator();
        dataSourceCreator.setBasicDataSourceCreator(this.basicDataSourceCreator());
        dataSourceCreator.setGbaseDataSourceCreator(this.gbaseDataSourceCreator());
        dataSourceCreator.setJndiDataSourceCreator(this.jndiDataSourceCreator());
        dataSourceCreator.setDruidDataSourceCreator(this.druidDataSourceCreator());
        dataSourceCreator.setHikariDataSourceCreator(this.hikariDataSourceCreator());
        dataSourceCreator.setGlobalPublicKey(this.properties.getPublicKey());
        return dataSourceCreator;
    }

    @Bean
    @ConditionalOnMissingBean
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @ConditionalOnMissingBean
    public GbaseDataSourceCreator gbaseDataSourceCreator() {
        return new GbaseDataSourceCreator(this.properties.getDbcp2());
    }

    @Bean
    @ConditionalOnMissingBean
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    @Bean
    @ConditionalOnMissingBean
    public DruidDataSourceCreator druidDataSourceCreator() {
        return new DruidDataSourceCreator(this.properties.getDruid());
    }

    @Bean
    @ConditionalOnMissingBean
    public HikariDataSourceCreator hikariDataSourceCreator() {
        return new HikariDataSourceCreator(this.properties.getHikari());
    }

    public DynamicDataSourceCreatorAutoConfiguration(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }
}

