/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.provider;

import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import cn.humingfeng.dynamic.datasource.toolkit.CryptoUtils;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.StringUtils;
import com.gbase.jdbc.jdbc2.optional.GBaseDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlDynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(MysqlDynamicDataSourceProvider.class);
    private static final String DRUID_DATASOURCE = "com.alibaba.druid.pool.DruidDataSource";
    private static final String HIKARI_DATASOURCE = "com.zaxxer.hikari.HikariDataSource";
    private static final String BASIC_DATASOURCE = "org.apache.commons.dbcp2.BasicDataSource";
    private static final String GBASE_DATASOURCE = "com.gbase.jdbc.jdbc2.optional.GBaseDataSource";
    private static String CREATE_TABLE_IF_NOT_EXISTS = "CREATE TABLE IF NOT EXISTS `data_source_config` (\n  ID int(11) NOT NULL AUTO_INCREMENT,\n  USER_NAME varchar(255) DEFAULT NULL COMMENT '\u7528\u6237\u540d',\n  PASSWORD varchar(255) DEFAULT NULL COMMENT '\u5bc6\u7801',\n  URL varchar(255) DEFAULT NULL COMMENT '\u5730\u5740',\n  DRIVER_CLASS_NAME varchar(500) DEFAULT NULL COMMENT '\u9a71\u52a8',\n  DB_NAME varchar(255) DEFAULT NULL COMMENT '\u6570\u636e\u6e90\u540d\u79f0',\n  TYPE varchar(255) DEFAULT NULL COMMENT '\u6570\u636e\u6e90\u7c7b\u578b',\n  PRIMARY KEY (ID)\n) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;";

    public Map<String, DataSourceProperty> run(DataSource dataSource) {
        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            jdbcTemplate.execute(CREATE_TABLE_IF_NOT_EXISTS);
            List maps = jdbcTemplate.queryForList("SELECT TYPE,DB_NAME,USER_NAME,PASSWORD,URL,DRIVER_CLASS_NAME FROM DATA_SOURCE_CONFIG");
            HashMap<String, DataSourceProperty> dataSourcePropertiesMap = new HashMap<String, DataSourceProperty>(3);
            for (Map map : maps) {
                String driver_class_name;
                String type = map.get("TYPE") == null ? "" : map.get("TYPE").toString();
                String db_name = map.get("DB_NAME") == null ? "" : map.get("DB_NAME").toString();
                String user_name = map.get("USER_NAME") == null ? "" : map.get("USER_NAME").toString();
                String password = map.get("PASSWORD") == null ? "" : map.get("PASSWORD").toString();
                String url = map.get("URL") == null ? "" : map.get("URL").toString();
                String string = driver_class_name = map.get("DRIVER_CLASS_NAME") == null ? "" : map.get("DRIVER_CLASS_NAME").toString();
                if (StringUtils.isEmpty((String)db_name) || StringUtils.isEmpty((String)user_name) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)driver_class_name)) {
                    log.error("param contain wrong in DATA_SOURCE_CONFIG  ");
                    return null;
                }
                DataSourceProperty dataSourceProperty = new DataSourceProperty();
                dataSourceProperty.setUrl(url);
                dataSourceProperty.setUsername(user_name);
                try {
                    dataSourceProperty.setPassword(CryptoUtils.decrypt(password));
                }
                catch (Exception e) {
                    log.warn(db_name + " password is not encrypt");
                    dataSourceProperty.setPassword(password);
                }
                dataSourceProperty.setDriverClassName(driver_class_name);
                switch (type) {
                    case "com.alibaba.druid.pool.DruidDataSource": {
                        dataSourceProperty.setType(DruidDataSource.class);
                        break;
                    }
                    case "com.zaxxer.hikari.HikariDataSource": {
                        dataSourceProperty.setType(HikariDataSource.class);
                        break;
                    }
                    case "org.apache.commons.dbcp2.BasicDataSource": {
                        dataSourceProperty.setType(BasicDataSource.class);
                        break;
                    }
                    case "com.gbase.jdbc.jdbc2.optional.GBaseDataSource": {
                        dataSourceProperty.setType(GBaseDataSource.class);
                        break;
                    }
                }
                dataSourcePropertiesMap.put(db_name, dataSourceProperty);
            }
            log.debug("others in DATA_SOURCE_CONFIG:" + dataSourcePropertiesMap);
            return dataSourcePropertiesMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

