/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.provider;

import cn.humingfeng.dynamic.datasource.creator.DataSourceCreator;
import cn.humingfeng.dynamic.datasource.provider.DynamicDataSourceProvider;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDataSourceProvider
implements DynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceProvider.class);
    @Autowired
    private DataSourceCreator dataSourceCreator;

    protected Map<String, DataSource> createDataSourceMap(Map<String, DataSourceProperty> dataSourcePropertiesMap) {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(dataSourcePropertiesMap.size() * 2);
        for (Map.Entry<String, DataSourceProperty> item : dataSourcePropertiesMap.entrySet()) {
            DataSourceProperty dataSourceProperty = item.getValue();
            String pollName = dataSourceProperty.getPollName();
            if (pollName == null || "".equals(pollName)) {
                pollName = item.getKey();
            }
            dataSourceProperty.setPollName(pollName);
            dataSourceMap.put(pollName, this.dataSourceCreator.createDataSource(dataSourceProperty));
        }
        return dataSourceMap;
    }
}

