/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.plugin;

import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import cn.humingfeng.dynamic.datasource.support.DbHealthIndicator;
import cn.humingfeng.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MasterSlaveAutoRoutingPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveAutoRoutingPlugin.class);
    @Autowired
    private DynamicDataSourceProperties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        boolean empty = true;
        try {
            empty = StringUtils.isEmpty((Object)DynamicDataSourceContextHolder.peek());
            if (empty) {
                DynamicDataSourceContextHolder.push(this.getDataSource(ms));
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (empty) {
                DynamicDataSourceContextHolder.clear();
            }
        }
    }

    public String getDataSource(MappedStatement mappedStatement) {
        boolean health;
        String slave = "slave";
        if (this.properties.isHealth() && !(health = DbHealthIndicator.getDbHealth("slave")) && (health = DbHealthIndicator.getDbHealth("master"))) {
            slave = "master";
        }
        return SqlCommandType.SELECT == mappedStatement.getSqlCommandType() ? slave : "master";
    }

    public Object plugin(Object target) {
        return target instanceof Executor ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }
}

